define("jira-project-config/permissions/js/permissions-data", ["wrm/data"], function (WRMData) {
    "use strict";

    /**
     * @typedef {Object} PCPPermissionsData
     * @property {Number} id id of a permission scheme
     * @property {String} name readable name of a permission scheme
     * @property {String} description description of a permission scheme
     * @property {Object} displayRendering contains permissions divided into groups
     * @property {Object} permissions list of permission details
     * @property {Object|null} operationResult not relevant for read-only view
     */

    /**
     * @type {PCPPermissionsData}
     * @exports jira_project_config/permissions/js/permissions_data
     */

    return Object.freeze(WRMData.claim("com.atlassian.jira.jira-project-config-plugin:permissions-data.permissionSchemeModel") || {});
});