define('jira-project-config/issuetypes/perspectives/workflow/workflowinfo/view', ['jira-project-config/marionette', 'jira-project-config/issuetypes/perspectives/workflow/workflowinfo/templates'], function (Marionette, Templates) {
    "use strict";

    /**
     * @class
     * @classdesc A view that renders the information panel within the workflow context.
     * @extends Marionette.ItemView
     */

    return Marionette.ItemView.extend({
        events: {
            "click #publish-draft": "_onPublishWorkflow",
            "click #discard-draft": "_onDiscardWorkflow"
        },

        modelEvents: {
            "change:issueType": "_issueTypeChanged"
        },

        initialize: function initialize() {
            if (this.model.get("issueType")) {
                this._reactOnWorkflowChange();
            }
        },

        /**
         * Disables or enables the buttons in the pluggable actions.
         * @param {Boolean} toggle if true, enables buttons, if false, disables buttons
         */
        disable: function disable(toggle) {
            this.$el.find("button").attr("aria-disabled", toggle).attr("disabled", toggle);
        },

        /**
         * @private
         */
        serializeData: function serializeData() {
            var workflow = this.model.get("issueType").get("workflow");
            return {
                workflowState: workflow && workflow.get("state"),
                isEditing: this.model.get("editing"),
                isDraftWithChanges: workflow && workflow.get("isDraftWithChanges")
            };
        },

        /**
         * @private
         */
        template: Templates.render,

        /**
         * @private
         */
        _onPublishWorkflow: function _onPublishWorkflow() {
            this.trigger("click:publish");
        },

        /**
         * @private
         */
        _onDiscardWorkflow: function _onDiscardWorkflow() {
            this.trigger("click:discard");
        },

        /**
         * @private
         */
        _issueTypeChanged: function _issueTypeChanged() {
            this.stopListening();
            this._reactOnWorkflowChange();
        },

        /**
         * Listens to nested workflow model "change" event.
         *
         * @private
         */
        _reactOnWorkflowChange: function _reactOnWorkflowChange() {
            var current = this.model.get("issueType");
            if (current.get("workflow")) {
                this.listenTo(current.get("workflow"), "change", this.render);
                this.render();
            }
        }
    });
});