AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab", "com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"], function () {
    "use strict";

    var _ = require("underscore");
    var Chance = require("jira-project-config/libs/chance");
    var ChanceMixins = require("jira-project-config/issuetypes/entities/test/chance-mixins");
    var jQuery = require("jquery");
    var WorkflowModel = require("jira-project-config/issuetypes/perspectives/workflow/model");
    var PluggableActionsView = require("jira-project-config/issuetypes/perspectives/workflow/pluggable-actions/view");

    var WorkflowControls = function WorkflowControls(el) {
        var $el = jQuery(el);
        this.editButton = $el.find("#edit_workflow");
        this.editPermissionButton = $el.find("#edit_workflow_permission");
        this.exitDraftButton = $el.find(".project-config-workflow__exit-draft");
    };
    _.extend(WorkflowControls.prototype, {
        clickEdit: function clickEdit() {
            this.editButton.click();
        },
        clickEditPermission: function clickEditPermission() {
            this.editPermissionButton.click();
        },
        isEditButtonEnabled: function isEditButtonEnabled() {
            return !this.editButton.is(":disabled");
        },
        isEditButtonPresent: function isEditButtonPresent() {
            return this.editButton.length > 0;
        },
        isEditPermissionButtonPresent: function isEditPermissionButtonPresent() {
            return this.editPermissionButton.length > 0;
        },

        clickExitDraft: function clickExitDraft() {
            this.exitDraftButton.click();
        },
        isExitDraftButtonPresent: function isExitDraftButtonPresent() {
            return this.exitDraftButton.length > 0;
        }
    });

    module("JIRA.ProjectConfig.IssueTypes.Workflow.PluggableActions.View", {
        createView: function createView(options, workflowState) {
            _.defaults({}, options, {
                editing: false
            });
            return new PluggableActionsView({
                model: new WorkflowModel({
                    editing: options.editing,
                    issueType: this.chance.issueType().set("workflow", this.chance.workflow().set("state", workflowState)),
                    project: this.chance.project()
                })
            });
        },

        setup: function setup() {
            this.sandbox = sinon.sandbox.create();

            this.chance = new Chance(1);
            _.extend(this.chance, new ChanceMixins());
        },

        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test("clicking edit workflow fires a click:edit event", function () {
        var clickEditSpy = this.sandbox.spy();
        var workflowControls;
        var view = this.createView({ editing: false });
        view.on("click:edit", clickEditSpy);

        workflowControls = new WorkflowControls(view.render().$el);
        workflowControls.clickEdit();

        sinon.assert.calledOnce(clickEditSpy);
    });

    test("clicking edit workflow by user with edit workflow permission fires a click:edit event", function () {
        var clickEditSpy = this.sandbox.spy();
        var workflowControls;
        var view = this.createView({ editing: false }, "editabledelegated");
        view.on("click:edit", clickEditSpy);

        workflowControls = new WorkflowControls(view.render().$el);
        workflowControls.clickEditPermission();

        sinon.assert.calledOnce(clickEditSpy);
    });

    test("should show Edit button only when viewing a workflow", function () {
        var view = this.createView({ editing: true });
        var workflowControls = new WorkflowControls(view.render().$el);

        notOk(workflowControls.isEditButtonPresent());
        notOk(workflowControls.isEditPermissionButtonPresent());
    });

    test("should fire a click:exitDraft event on Exit draft button click", function () {
        var clickSpy = this.sandbox.spy();
        var workflowControls;
        var view = this.createView({ editing: true });
        view.on("click:exitDraft", clickSpy);

        workflowControls = new WorkflowControls(view.render().$el);
        workflowControls.clickExitDraft();

        sinon.assert.calledOnce(clickSpy);
    });

    test("should show Exit draft button only when editing a workflow", function () {
        var view = this.createView({ editing: false });
        var workflowControls = new WorkflowControls(view.render().$el);

        notOk(workflowControls.isExitDraftButtonPresent());
    });

    test("disable() disables the edit button", function () {
        var view = this.createView({ editing: false });
        var workflowControls = new WorkflowControls(view.render().$el);

        ok(workflowControls.isEditButtonEnabled(), "edit button should be enabled");
        view.disable(true);
        ok(!workflowControls.isEditButtonEnabled(), "edit button should be disabled");
    });
});