define("jira-project-config/issuetypes/perspectives/workflow/analytics", ["jira/analytics"], function (analytics) {
    "use strict";

    /**
     * @param name {string} event name
     * @param eventData {{isolated: bool, admin: bool, projectId: int, workflowHash: string, workflowState: string, hasChanges: bool}}
     * @returns {{name: *, properties: *}}
     */

    var buildEventData = function buildEventData(name, eventData) {
        return {
            name: name,
            properties: eventData
        };
    };

    return {
        triggerViewProject: function triggerViewProject(eventData) {
            analytics.send(buildEventData("administration.workflow.open.view.project", eventData));
        },

        triggerEditProject: function triggerEditProject(eventData) {
            analytics.send(buildEventData("administration.workflow.open.edit.project", eventData));
        },

        triggerDiscardEditedWorkflow: function triggerDiscardEditedWorkflow(eventData) {
            analytics.send(buildEventData("administration.project.discard.edited.workflow", eventData));
        },

        triggerDiscardEditedWorkflowFail: function triggerDiscardEditedWorkflowFail(eventData) {
            analytics.send(buildEventData("administration.project.discard.edited.workflow.failed", eventData));
        },

        triggerPublishEditedWorkflow: function triggerPublishEditedWorkflow(eventData) {
            analytics.send(buildEventData("administration.project.publish.edited.workflow", eventData));
        },

        triggerPublishEditedWorkflowFail: function triggerPublishEditedWorkflowFail(eventData) {
            analytics.send(buildEventData("administration.project.publish.edited.workflow.failed", eventData));
        },

        triggerEditedWorkflowClicked: function triggerEditedWorkflowClicked(eventData) {
            analytics.send(buildEventData("administration.project.edit.workflow", eventData));
        },

        triggerExitDraftClicked: function triggerExitDraftClicked(eventData) {
            analytics.send(buildEventData("administration.project.workflow.exit.draft", eventData));
        }
    };
});