AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab", "com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"], function () {
    "use strict";

    var analytics = require('jira/analytics');
    var Analytics = require('jira-project-config/issuetypes/perspectives/workflow/analytics');

    module("JIRA.ProjectConfig.IssueTypes.Workflow.Analytics", {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(analytics, "send");
        },

        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test("Correct analytic events are sent", function () {
        var data = [["triggerViewProject", "administration.workflow.open.view.project"], ["triggerEditProject", "administration.workflow.open.edit.project"], ["triggerDiscardEditedWorkflow", "administration.project.discard.edited.workflow"], ["triggerDiscardEditedWorkflowFail", "administration.project.discard.edited.workflow.failed"], ["triggerPublishEditedWorkflow", "administration.project.publish.edited.workflow"], ["triggerPublishEditedWorkflowFail", "administration.project.publish.edited.workflow.failed"], ["triggerEditedWorkflowClicked", "administration.project.edit.workflow"], ["triggerExitDraftClicked", "administration.project.workflow.exit.draft"]];
        var properties = { admin: false };

        for (var i = 0; i < data.length; i++) {
            var method = data[i][0];
            var keyName = data[i][1];

            analytics.send.reset();
            Analytics[method](properties);
            sinon.assert.calledWith(analytics.send, { name: keyName, properties: properties });
        }
    });
});