define("jira-project-config/issuetypes/perspectives/fields/view", ["require"], function (require) {
    "use strict";

    var Marionette = require('jira-project-config/marionette');
    var TemplateTab = require('jira-project-config/issuetypes/perspectives/fields/templates');
    var ScreenEditorApplication = require('jira-project-config/screen-editor');
    /** @type PCPAnalyticsCommonData */
    var AnalyticsCommonData = require('jira-project-config/global/js/analytics-common-data');

    /**
     * @class
     * @classdesc A view that handles rendering the entire right side of the screen. It renders the screen editor
     *   for a single issue type in a project.
     * @constructor
     * @extends Marionette.ItemView
     */
    return Marionette.ItemView.extend(
    /** @lends JIRA.ProjectConfig.IssueTypes.Fields.View */
    {
        ui: {
            screenEditor: "#screenEditor"
        },

        /**
         * Attempts to start the screen editor.
         *
         * @private
         */
        onShow: function onShow() {
            this.editor = new ScreenEditorApplication({
                element: this.ui.screenEditor,
                screenId: this.model.get("screenId"),
                readOnly: !this.model.get("canEdit"),
                projectKey: this.model.get("project").get("key"),
                analyticsName: "project",
                analyticsData: AnalyticsCommonData
            });
        },

        template: TemplateTab.render
    });
});