define('jira-project-config/issuetypes/header/view', ['require'], function (require) {
    "use strict";

    var TemplateHeader = require('jira-project-config/issuetypes/header/templates');
    var Marionette = require("jira-project-config/marionette");

    /**
     * @class
     * @classdesc A layout that defines the various regions of the issue types header.
     * @extends Marionette.Layout
     */
    return Marionette.Layout.extend(
    /** @lends JIRA.ProjectConfig.IssueTypes.Header.View# */
    {
        /**
         * The regions of this layout.
         *  - descriptor: the region where a description of the perspective is rendered.
         *  - perspectives: the region where the possible perspectives are rendered to be switched between.
         *  - pluggableActions: the region where pluggable actions can be rendered by interested parties.
         */
        regions: {
            descriptor: "#project-issuetypes-descriptor",
            actions: "#project-issuetypes-actions",
            readOnly: "#lozenge-read-only",
            sharedBy: "#project-issuetypes-shared-by",
            infoMessage: "#info-message",
            perspectives: "#project-issuetypes-perspectives"
        },
        className: 'aui-page-header project-config-panel-header',

        template: TemplateHeader.render
    });
});