define('jira-project-config/issuetypes/header/shared-by/view', ['require'], function (require) {
    "use strict";

    var Marionette = require("jira-project-config/marionette");
    var UsedByTemplates = require('jira-project-config/templates/usedby');
    var $ = require('jquery');

    return Marionette.ItemView.extend({
        serializeData: function serializeData() {
            var data = this.model.toJSON();
            data.projects = data.projects.toJSON();
            data.issueTypes = data.issueTypes.map(function (item) {
                return item.pick("id", "name", "url");
            });

            data.minProjects = 2;

            return data;
        },

        template: UsedByTemplates.usedBy,

        onRender: function onRender() {
            var self = this;
            this.$el.find('.shared-issuetypes-list').on('click', 'a', function (e) {
                self.trigger("issueType:selected", self.model.get("issueTypes").findWhere({
                    id: $(e.target).data("issueTypeId").toString()
                }));
            });
        },

        onBeforeClose: function onBeforeClose() {
            this.$el.find('.shared-items-trigger').each(function () {
                $($(this).attr('href')).remove();
            });
        }
    });
});