define('jira-project-config/issuetypes/header/perspectives/view', ['require'], function (require) {
    "use strict";

    var TemplatePerspectives = require('jira-project-config/issuetypes/header/perspectives/view/templates');
    var Marionette = require("jira-project-config/marionette");
    var keyCodes = require("jira/util/key-code");

    var PerspectiveItemView = Marionette.ItemView.extend({
        events: {
            simpleClick: "_perspectiveSelected",
            "keydown": "_keyDown"
        },

        id: function id() {
            return "project-issuetypes-perspective-" + this.model.get("id");
        },

        className: "project-issuetype-perspective aui-button",

        tagName: "button",

        template: TemplatePerspectives.renderPerspective,

        onRender: function onRender() {
            this.$el.attr("aria-pressed", this.model.get('selected'));
        },

        _perspectiveSelected: function _perspectiveSelected() {
            this.trigger("perspective:selected", this.model);
        },

        _keyDown: function _keyDown(event) {
            if (event.keyCode === keyCodes.ENTER) {
                this._perspectiveSelected();
            }
        }
    });

    return Marionette.CollectionView.extend(
    /** @lends JIRA.ProjectConfig.IssueTypes.Header.Perspectives.View# */
    {
        className: "perspective-items aui-buttons",

        /**
         * Initializes the view.
         *
         * @classdesc A view for showing controls for each perspective, allowing switching between perspectives.
         * @constructs
         */
        initialize: function initialize(options) {
            this.model = options.model;
            this.collection = options.model.get("perspectives");
        },

        itemEvents: {
            "perspective:selected": function perspectiveSelected(eventName, childView, model) {
                this.trigger("perspective:selected", model);
            }
        },

        modelEvents: {
            "change:selectedPerspective": "render"
        },

        itemView: PerspectiveItemView,

        onBeforeRender: function onBeforeRender() {
            var selectedPerspective = this.model.get('selectedPerspective');

            this.collection.each(function (perspective) {
                perspective.set('selected', selectedPerspective && perspective.get('id') === selectedPerspective.get('id'));
            });
        },

        togglePerspectivesVisibility: function togglePerspectivesVisibility(shouldBeVisible) {
            if (shouldBeVisible) {
                this.$el.show();
            } else {
                this.$el.hide();
            }
        }
    });
});