AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab"], function () {
    "use strict";

    var _ = require("underscore");
    var jQuery = require("jquery");
    var HeaderDescriptor = require("jira-project-config/issuetypes/entities/models/header-descriptor");
    var HeaderDescriptorView = require("jira-project-config/issuetypes/header/descriptor/view");

    var DescriptorPageObject = function DescriptorPageObject(el) {
        this.$el = jQuery(el);
    };
    _.extend(DescriptorPageObject.prototype, {
        getTitle: function getTitle() {
            return this.$el.find("#project-config-header-descriptor-title").text();
        }
    });

    module("JIRA.ProjectConfig.IssueTypes.Header.Descriptor.View", {
        createView: function createView(model) {
            return new HeaderDescriptorView({ model: model });
        }
    });

    test("title and subtitle are rendered into the title and subtitle elements respectively", function () {
        var descriptorPageObject;
        var model = new HeaderDescriptor({
            title: "my title"
        });

        var view = this.createView(model);

        descriptorPageObject = new DescriptorPageObject(view.render().$el);

        equal(descriptorPageObject.getTitle(), "my title", "title in model should be rendered");
    });
});