AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab","com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"],function(){"use strict";var e=require("jira-project-config/marionette"),s=require("underscore"),t=require("jira-project-config/libs/chance"),i=require("jira-project-config/issuetypes/entities/test/chance-mixins"),o=require("jira-project-config/backbone"),n=require("jira-project-config/issuetypes/header/descriptor/view"),a=require("jira-project-config/issuetypes/header/perspectives/view"),r=require("jira-project-config/issuetypes/header/shared-by/view"),c=require("jira-project-config/issuetypes/header/view"),l=require("jira-project-config/issuetypes/header/readonly/view");module("JIRA.ProjectConfig.IssueTypes.Header.Controller",{createMockAnalytics:function(){var e={send:this.sandbox.spy()};return this.context.mock("jira/analytics",e),e},createMockHeaderDescriptorView:function(){var e={render:this.sandbox.spy()};return this.context.mock("jira-project-config/issuetypes/header/descriptor/view",function(){return e}),e},createMockHeaderView:function(){var e={actions:{close:this.sandbox.spy(),show:this.sandbox.spy()},descriptor:{close:this.sandbox.spy(),show:this.sandbox.spy()},readOnly:{close:this.sandbox.spy(),show:this.sandbox.spy()},infoMessage:{close:this.sandbox.spy(),show:this.sandbox.spy()},perspectives:{close:this.sandbox.spy(),show:this.sandbox.spy()},sharedBy:{close:this.sandbox.spy(),show:this.sandbox.spy()}};return this.context.mock("jira-project-config/issuetypes/header/view",function(){return e}),e},createNewHeaderController:function(e){return new(this.context.require("jira-project-config/issuetypes/header/controller"))(s.defaults({},e,{commands:this.commands,model:this.model,perspectives:this.defaultPerspectives,region:this.region,reqres:this.reqres,vent:this.vent}))},setup:function(){this.sandbox=sinon.sandbox.create(),this.commands=new e.Wreqr.Commands,this.context=AJS.test.mockableModuleContext(),this.reqres=new e.Wreqr.RequestResponse,this.vent=new e.Wreqr.EventAggregator,this.region={show:this.sandbox.spy()},this.chance=new t(1),s.extend(this.chance,new i),this.bug=this.chance.issueType(),this.story=this.chance.issueType(),this.project=this.chance.project(),this.project.set({key:"PTE"}),this.perspective1=this.chance.perspective(),this.perspective2=this.chance.perspective(),this.perspective3=this.chance.perspective(),this.defaultPerspectives=[this.perspective1,this.perspective2,this.perspective3],this.model=new o.Model({selectedIssueType:this.bug,selectedPerspective:this.perspective1,project:this.project,editing:void 0})},teardown:function(){this.sandbox.restore()}}),test("Executing issueTypes:resetPluggableRegions closes all regions and re-initializes nothing when no options provided",function(){var e=this.createMockHeaderView();this.createNewHeaderController().show(),this.commands.execute("issueTypes:resetPluggableRegions"),equal(e.actions.close.callCount,1,"actions close() should have been called once"),equal(e.descriptor.close.callCount,1,"descriptor close() should have been called once"),equal(e.readOnly.close.callCount,1,"readOnly close() should have been called once"),equal(e.infoMessage.close.callCount,1,"infoMessage close() should have been called once"),sinon.assert.notCalled(e.actions.show,"actions show() should not have been called"),sinon.assert.notCalled(e.descriptor.show,"descriptor show() should not have been called"),sinon.assert.notCalled(e.readOnly.show,"readOnly show() should not have been called"),sinon.assert.notCalled(e.infoMessage.show,"infoMessage show() should not have been called")}),test("Executing issueTypes:resetPluggableRegions shows descriptor view in header when descriptor in options",function(){var e=this.createMockHeaderView(),s=this.sandbox.spy(n);this.context.mock("jira-project-config/issuetypes/header/descriptor/view",s);var t=this.chance.headerDescriptor();this.createNewHeaderController().show(),equal(e.descriptor.show.callCount,0,"show() should not yet have been called"),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:t}),equal(e.descriptor.show.callCount,1,"show() should have been called once"),ok(e.descriptor.show.firstCall.args[0]instanceof n,"View passed to show() should be the descriptor view"),deepEqual(s.firstCall.args[0],{model:t},"Model passed to View should be that which is passed to issueTypes:resetPluggableRegions")}),test("Executing issueTypes:resetPluggableRegions shows shared by view in header when shared by data in options",function(){var e=this.createMockHeaderView(),s=this.sandbox.spy(r);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",s);var t=this.chance.sharedByData();this.createNewHeaderController().show(),equal(e.sharedBy.show.callCount,0,"show() should not yet have been called."),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model,sharedBy:t}),equal(e.sharedBy.show.callCount,1,"show() should have been called."),ok(e.sharedBy.show.firstCall.args[0]instanceof r,"View passed to show() should be the shared by view"),deepEqual(s.firstCall.args[0],{model:t},"Model passed to View should be that which is passed to issueTypes:resetPluggableRegions")}),test("Executing issueTypes:resetPluggableRegions shows actions view in header when actions in options",function(){var e=this.createMockHeaderView(),s=new o.View;this.createNewHeaderController().show(),equal(e.actions.show.callCount,0,"show() should not yet have been called"),this.commands.execute("issueTypes:resetPluggableRegions",{actions:s}),equal(e.actions.show.callCount,1,"show() should have been called once"),ok(e.actions.show.firstCall.args[0]===s,"View passed to show() should be the view created")}),test("Executing issueTypes:resetPluggableRegions shows info view in header when info in options",function(){var e=this.createMockHeaderView(),s=new o.View;this.createNewHeaderController().show(),equal(e.infoMessage.show.callCount,0,"show() should not yet have been called"),this.commands.execute("issueTypes:resetPluggableRegions",{info:s}),equal(e.infoMessage.show.callCount,1,"show() should have been called once"),ok(e.infoMessage.show.firstCall.args[0]===s,"View passed to show() should be the view created")}),test("Executing issueTypes:resetPluggableRegions shows readonly lozenge in header when workflow in options",function(){var e=this.createMockHeaderView(),s=new o.Model,t=this.sandbox.spy(l);this.context.mock("jira-project-config/issuetypes/header/readonly/view",t),this.createNewHeaderController().show(),sinon.assert.notCalled(e.readOnly.show,"show() should not yet have been called"),this.commands.execute("issueTypes:resetPluggableRegions",{readOnly:s}),equal(e.readOnly.show.callCount,1,"show() should have been called once"),ok(e.readOnly.show.firstCall.args[0]instanceof l)}),test("show() renders a Header view in the provided region",function(){this.context.mock("jira-project-config/issuetypes/header/view",c),this.createNewHeaderController().show(),equal(this.region.show.callCount,1,"show() should not yet have been called."),ok(this.region.show.firstCall.args[0]instanceof c)}),test("Perspectives are rendered in the perspectives region of the HeaderView on issueTypes:resetPluggableRegions event",function(){this.context.mock("jira-project-config/issuetypes/header/perspectives/view",a);var e=this.createMockHeaderView(),s=this.createNewHeaderController();equal(e.perspectives.show.callCount,0,"show() should not yet have been called."),s.show(),equal(e.perspectives.show.callCount,1,"show() should have been called."),ok(e.perspectives.show.firstCall.args[0]instanceof a,"parameter passed to show() should be a Perspectives View")}),test("When Perspectives view fires perspective:selected, a header:perspectiveSelected event is fired on vent",function(){var e=this.sandbox.spy();this.vent.on("header:perspectiveSelected",e);var s=new o.View,t=this.sandbox.stub().returns(s);this.context.mock("jira-project-config/issuetypes/header/perspectives/view",t),this.createNewHeaderController().show(),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model({})}),equal(e.callCount,0,"header:perspectiveSelected should not yet have been fired"),s.trigger("perspective:selected",this.perspective3),equal(e.callCount,1,"header:perspectiveSelected should have been fired once"),equal(e.firstCall.args[0],this.perspective3,"header:perspectiveSelected should have been fired with correct parameter")}),test("When Perspectives view fires perspective:selected, analytics are send",function(){var e=this.createMockAnalytics(),s=new o.View,t=this.sandbox.stub().returns(s);this.context.mock("jira-project-config/issuetypes/header/perspectives/view",t),this.createNewHeaderController().show(),equal(e.send.callCount,0,"Analytics.send should not yet have been fired"),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model({})}),equal(e.send.callCount,0,"Analytics.send should not yet have been fired"),s.trigger("perspective:selected",this.perspective3),equal(e.send.callCount,1,"Analytics.send should have been fired once"),ok(e.send.calledWith({name:"administration.issuetypes.perspective."+this.perspective3.get("id")}))}),test("When Shared by view is displayed, and it fires issueType:selected, a header:issueTypeSelected is fired on vent",function(){var e=this.sandbox.spy();this.vent.on("header:issueTypeSelected",e);var s=new o.View,t=this.sandbox.stub().returns(s);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",t),this.createNewHeaderController().show(),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model,sharedBy:new o.Model}),equal(e.callCount,0,"header:issueTypeSelected should not yet have been fired"),s.trigger("issueType:selected",this.story),equal(e.callCount,1,"header:issueTypeSelected should have been fired once"),equal(e.firstCall.args[0],this.story,"header:issueTypeSelected should have been fired with correct parameter")}),test("When Shared by view is displayed, and it fires close, controller stops listening to it",function(){var e=new o.View,s=this.sandbox.stub().returns(e);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",s);var t=this.createNewHeaderController();t.show();var i=this.sandbox.spy(t,"stopListening");this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model,sharedBy:new o.Model}),equal(i.callCount,0,"stopListening() should not yet have been called"),e.trigger("close"),equal(i.callCount,1,"stopListening() should have been called once"),ok(i.firstCall.args[0]===e,"stopListening() should have been called with the shared by view")}),test("When Perspectives view is displayed, and it fires close, controller stops listening to it",function(){var e=new o.View,s=this.sandbox.stub().returns(e);this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s);var t=this.createNewHeaderController();t.show(),this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:new o.Model({})});var i=this.sandbox.spy(t,"stopListening");equal(i.callCount,0,"stopListening() should not yet have been called"),e.trigger("close"),equal(i.callCount,1,"stopListening() should have been called once"),ok(i.firstCall.args[0]===e,"stopListening() should have been called with the perspectives view")}),test("Should hide perspectives when pageModel.editing was changed to true",function(){var e=new o.View,s=this.sandbox.stub().returns(e),t=this.sandbox.spy();e.togglePerspectivesVisibility=t,this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s),this.createNewHeaderController().show(),sinon.assert.notCalled(t),this.model.set("editing",!0),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!1)}),test("Should show perspectives when pageModel.editing was changed to false",function(){var e=new o.View,s=this.sandbox.stub().returns(e),t=this.sandbox.spy();e.togglePerspectivesVisibility=t,this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s),this.createNewHeaderController().show(),sinon.assert.notCalled(t),this.model.set("editing",!1),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!0)}),test("Should hide and show perspectives when pageModel.editing was changed to true and to false",function(){var e=new o.View,s=this.sandbox.stub().returns(e),t=this.sandbox.spy();e.togglePerspectivesVisibility=t,this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s),this.createNewHeaderController().show(),sinon.assert.notCalled(t),this.model.set("editing",!0),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!1),this.model.set("editing",!1),sinon.assert.calledTwice(t),sinon.assert.calledWith(t,!0)}),test("Should not react when the value of pageModel.editing wasn't changed and was falsy",function(){var e=new o.View,s=this.sandbox.stub().returns(e),t=this.sandbox.spy();e.togglePerspectivesVisibility=t,this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s),this.createNewHeaderController().show(),sinon.assert.notCalled(t),this.model.set("editing",!1),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!0),this.model.set("editing",!1),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!0)}),test("Should not react when the value of pageModel.editing wasn't changed and was truthy",function(){var e=new o.View,s=this.sandbox.stub().returns(e),t=this.sandbox.spy();e.togglePerspectivesVisibility=t,this.context.mock("jira-project-config/issuetypes/header/perspectives/view",s),this.createNewHeaderController().show(),sinon.assert.notCalled(t),this.model.set("editing",!0),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!1),this.model.set("editing",!0),sinon.assert.calledOnce(t),sinon.assert.calledWith(t,!1)})});