define('jira-project-config/issuetypes/entities/models/screen', ['require'], function (require) {
  "use strict";

  var _ = require('underscore');
  var Backbone = require('jira-project-config/backbone');
  var Projects = require("jira-project-config/issuetypes/entities/models/projects");
  var IssueTypes = require("jira-project-config/issuetypes/entities/models/issue-types");

  /**
   * @class
   * @classdesc A basic description of a screen.
   * @extends Backbone.Model
   */
  return Backbone.Model.extend(
  /** @lends JIRA.ProjectConfig.IssueTypes.Entities.Screen# */
  {
    defaults: {
      /**
       * Total number of sharing projects (including those not visible to the current user).
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {number}
       */
      totalProjectsCount: 0,

      /**
       * The number of sharing projects not visible to the current user.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {number}
       */
      hiddenProjectsCount: 0,

      /**
       * Other projects that share the same set of fields.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {JIRA.ProjectConfig.IssueTypes.Entities.Projects}
       */
      sharedWithProjects: new Projects(),

      /**
       * Other issue types that share the same set of fields.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {JIRA.ProjectConfig.IssueTypes.Entities.IssueTypes}
       */
      sharedWithIssueTypes: new IssueTypes(),

      /**
       * The screen's ID, e.g. `54354`. Should always be provided.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {number}
       */
      screenId: undefined,

      /**
       * The name of the screen. Should always be provided.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {string}
       */
      screenName: undefined,

      /**
       * When non-`null`, the value must be one of:
       *
       *  - `"nopermission"` for a user who can't edit the workflow.
       *  - `"readonly"` for a workflow that can never be edited.
       *  - `"readonlydelegatedshared"` for a workflow that can not be edited by user that have workflow edit permission because workflow is shared.
       *  - `"editable"` for a workflow that can be edited.
       *
       * Should always be provided.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {string}
       */
      state: undefined,

      /**
       * Can sceen be edited in the given context. Should always be provided.
       *
       * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Screen#
       * @type {boolean}
       */
      canEdit: undefined
    },

    toJSON: function toJSON() {
      return _.extend({}, this.attributes, {
        sharedWithProjects: this.attributes.sharedWithProjects.toJSON(),
        sharedWithIssueTypes: this.attributes.sharedWithIssueTypes.toJSON()
      });
    }
  });
});