AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-entities", "com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"], function () {
    "use strict";

    var _ = require("underscore");
    var IssueType = require("jira-project-config/issuetypes/entities/models/issue-type");
    var Chance = require("jira-project-config/libs/chance");
    var Fields = require("jira-project-config/issuetypes/entities/models/fields");
    var ChanceMixins = require("jira-project-config/issuetypes/entities/test/chance-mixins");

    module("JIRA.ProjectConfig.IssueTypes.Entities.IssueType", {
        setup: function setup() {
            this.chance = new Chance(1);
            _.extend(this.chance, new ChanceMixins());
        },

        makeScreen: function makeScreen(screen, type) {
            return _.extend({}, screen, { type: type });
        }
    });

    test("Defaults", function () {
        var issueType = new IssueType();

        equal(issueType.get("id"), undefined);
        equal(issueType.get("fields"), undefined);
        equal(issueType.get("name"), undefined);
        equal(issueType.get("workflow"), undefined);
    });

    test("toJSON() serialises empty child models", function () {
        var issueType = new IssueType();

        deepEqual(issueType.toJSON(), {
            id: undefined,
            fields: undefined,
            name: undefined,
            workflow: undefined
        });
    });

    test("toJSON() serialises populated child models", function () {
        var fields = this.chance.fields();
        var workflow = this.chance.workflow();

        var issueType = new IssueType({
            fields: fields,
            workflow: workflow

        });

        deepEqual(issueType.toJSON(), {
            id: undefined,
            fields: fields.toJSON(),
            name: undefined,
            workflow: workflow.toJSON()
        });
    });

    test("getScreens() return empty array when there is no fields", function () {
        var issueType = new IssueType();
        deepEqual(issueType.getScreens(), [], 'Shoud return empty array');
    });

    test("getScreens() returns screens in specific order when there are fields", function () {
        var viewScreen = this.chance.screen();
        var issueType = new IssueType();
        issueType.set({
            fields: new Fields({
                viewScreen: viewScreen
            })
        });
        deepEqual(issueType.getScreens().map(function (screen) {
            return screen.toJSON();
        }), [this.makeScreen(viewScreen, 'view').toJSON()], 'Should return entries in proper order');
    });
});