define('jira-project-config/issuetypes/entities/models/header-descriptor', ["require"], function (require) {
    "use strict";

    var Backbone = require('jira-project-config/backbone');

    /**
     * @class
     * @classdesc The data required to render a {@link JIRA.ProjectConfig.IssueTypes.Header.Descriptor.View}.
     * @extends Backbone.Model
     */
    return Backbone.Model.extend({
        /** @lends JIRA.ProjectConfig.IssueTypes.Entities.HeaderDescriptor# */
        defaults: function defaults() {
            return {
                /**
                 * The title of the header. Should always be provided.
                 *
                 * @memberof JIRA.ProjectConfig.IssueTypes.Entities.HeaderDescriptor#
                 * @type {string}
                 */
                title: undefined
            };
        }
    });
});