define('jira-project-config/issuetypes/entities/models/fields', ['require'], function (require) {
    "use strict";

    var Backbone = require('jira-project-config/backbone');
    var _ = require('underscore');
    var Screen = require("jira-project-config/issuetypes/entities/models/screen");

    /**
     * @class
     * @classdesc References related entities involved in the fields of an issue type.
     * @extends Backbone.Model
     */
    return Backbone.Model.extend(
    /** @lends JIRA.ProjectConfig.IssueTypes.Entities.Fields# */
    {
        defaults: function defaults() {
            return {
                /**
                 * Representation of the 'view screen'. Should always be provided.
                 *
                 * @memberof JIRA.ProjectConfig.IssueTypes.Entities.Fields#
                 */
                viewScreen: new Screen()
            };
        },
        getScreen: function getScreen(screenId) {
            return this.get(screenId + 'Screen');
        },

        toJSON: function toJSON() {
            return _.extend({}, this.attributes, {
                viewScreen: this.attributes.viewScreen.toJSON()
            });
        }
    });
});