var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-entities"], function () {
    "use strict";

    var Fields = require("jira-project-config/issuetypes/entities/models/fields");
    var IssueTypes = require("jira-project-config/issuetypes/entities/models/issue-types");
    var Projects = require("jira-project-config/issuetypes/entities/models/projects");
    var Screen = require("jira-project-config/issuetypes/entities/models/screen");

    module("JIRA.ProjectConfig.IssueTypes.Entities.Fields");

    test("Defaults", function () {
        var fields = new Fields();
        var viewScreen = fields.get("viewScreen");
        ok(viewScreen instanceof Screen);
        equal(viewScreen.get("screenName"), undefined);
        ok(viewScreen.get("sharedWithProjects") instanceof Projects);
        ok(viewScreen.get("sharedWithIssueTypes") instanceof IssueTypes);
        equal(viewScreen.get("screenId"), undefined);

        equal(_typeof(viewScreen.get("totalProjectsCount")), "number");
        equal(viewScreen.get("totalProjectsCount"), 0);

        equal(_typeof(viewScreen.get("hiddenProjectsCount")), "number");
        equal(viewScreen.get("hiddenProjectsCount"), 0);
    });

    test("toJSON() serialises child collections", function () {
        var fields = new Fields();

        deepEqual(fields.toJSON(), {
            viewScreen: new Screen().toJSON()
        });
    });
});