define("jira-project-config/issuetypes/entities/entityParser", ['underscore', 'jira-project-config/issuetypes/entities/models/workflow', 'jira-project-config/issuetypes/entities/models/project', 'jira-project-config/issuetypes/entities/models/projects', 'jira-project-config/issuetypes/entities/models/issue-types'], function (_, Workflow, Project, Projects, IssueTypes) {
    "use strict";

    /**
     * Make a Projects (model) out of plain JavaScript objects.
     *
     * @param {object[]} projectsData An array of project data, e.g. [{id: 1, key: "FOO", name: "Fast Or Out"}]
     * @returns {JIRA.ProjectConfig.IssueTypes.Entities.Projects}
     */

    function makeProjects(projectsData) {
        var projects = _.map(projectsData, function makeProject(projectData) {
            var project = _.pick(projectData, "id", "key", "name");
            return new Project(project);
        });

        return new Projects(projects);
    }

    /**
     * Make a IssueTypes (model) out of plain JavaScript objects.
     *
     * @param {object[]} ids An array of issue type IDs, e.g. [1, 3, 2]
     * @param {JIRA.ProjectConfig.IssueTypes.Entities.IssueTypes} lookup A library of issue type data to pull from.
     * @returns {JIRA.ProjectConfig.IssueTypes.Entities.IssueTypes}
     */
    function makeIssueTypes(ids, lookup) {
        return new IssueTypes(_.map(ids, _.bind(lookup.get, lookup)));
    }

    return {
        makeWorkflow: function makeWorkflow(workflowData, issueTypes) {
            return new Workflow({
                name: workflowData.name,
                displayName: workflowData.displayName,
                state: workflowData.state,
                updatedDate: workflowData.updatedDate,
                isDraftWithChanges: !!workflowData.isDraftWithChanges,
                totalProjectsCount: workflowData.totalProjectsCount,
                hiddenProjectsCount: workflowData.hiddenProjectsCount,
                sharedWithProjects: makeProjects(workflowData.sharedWithProjects),
                sharedWithIssueTypes: makeIssueTypes(workflowData.sharedWithIssueTypes, issueTypes)
            });
        },

        makeProjects: makeProjects,
        makeIssueTypes: makeIssueTypes
    };
});