AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-entities", "com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"], function () {
    "use strict";

    var _ = require("underscore");
    var entityParser = require("jira-project-config/issuetypes/entities/entityParser");
    var Chance = require("jira-project-config/libs/chance");
    var ChanceMixins = require("jira-project-config/issuetypes/entities/test/chance-mixins");
    var IssueTypes = require("jira-project-config/issuetypes/entities/models/issue-types");

    module("entityParser", {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();

            this.chance = new Chance(1);
            _.extend(this.chance, new ChanceMixins());
        },

        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test("should parse and return proper workflow", function () {
        var it1 = this.chance.issueType();
        var it2 = this.chance.issueType();
        var project = this.chance.project();

        var workflowData = {
            name: 'Workflow name',
            displayName: 'Display name',
            state: 'Some state',
            updatedDate: 'Updated date',
            isDraftWithChanges: true,
            totalProjectsCount: 123,
            hiddenProjectsCount: 234,
            sharedWithProjects: [project.toJSON()],
            sharedWithIssueTypes: [it1.get("id")]
        };
        var issueTypes = new IssueTypes([it2, it1]);

        var workflow = entityParser.makeWorkflow(workflowData, issueTypes);

        deepEqual(_.pick(workflow.attributes, 'name', 'displayName', 'state', 'updatedDate', 'isDraftWithChanges', 'totalProjectsCount', 'hiddenProjectsCount'), {
            name: 'Workflow name',
            displayName: 'Display name',
            state: 'Some state',
            updatedDate: 'Updated date',
            isDraftWithChanges: true,
            totalProjectsCount: 123,
            hiddenProjectsCount: 234
        });
        equal(workflow.get('sharedWithProjects').length, 1);
        deepEqual(workflow.get('sharedWithProjects').at(0).attributes, {
            id: project.get('id'),
            key: project.get('key'),
            name: project.get('name')
        });
        equal(workflow.get('sharedWithIssueTypes').length, 1);
        deepEqual(workflow.get('sharedWithIssueTypes').at(0).attributes, {
            id: it1.get('id'),
            name: it1.get('name'),
            fields: undefined,
            workflow: undefined
        });
    });
});