require(['jira/skate', 'jira/analytics', 'jquery'], function (skate, analytics, $) {
    "use strict";

    function emitEventOnClick(element, linkType) {
        if (!element) {
            return;
        }

        element.on("click.usedByAnalytics", function () {
            analytics.send({
                name: 'jira.projectconfig.usedby.used',
                data: { linkType: linkType }
            });
        });
    }

    skate('used-by-analytics', {
        type: skate.type.ELEMENT,
        attached: function attachAnalyticsHandler(element) {
            var usedByRoot = element.getLozengeRoot();
            emitEventOnClick(usedByRoot.find(".shared-issuetypes-trigger"), "issuetypes");
            emitEventOnClick(usedByRoot.find(".shared-projects-trigger"), "project");
        },
        detached: function detached(element) {
            element.getLozengeRoot().find(".shared-items-trigger").off("click.usedByAnalytics");
        },
        prototype: {
            getLozengeRoot: function getLozengeRoot() {
                return $(this).parent();
            }
        }
    });
});