define('jira-project-config/global/js/projectconfig/modules/urls/workflow/manager', ['jira-project-config/workflow/templates', 'underscore'], function (WorkflowTemplates, _) {
    "use strict";

    /**
     * @param {JIRA.ProjectConfig.IssueTypes.Entities.Project|string} options.project the project or its key
     * @param {JIRA.ProjectConfig.IssueTypes.Entities.Workflow|string} options.workflow the workflow or its name
     * @returns {Object}
     */

    function parseOptions(options) {
        return {
            projectKey: typeof options.project === 'string' ? options.project : options.project.get("key"),
            workflowName: typeof options.workflow === 'string' ? options.workflow : options.workflow.get("name")
        };
    }

    /**
     * @class
     * @classdesc An API for retrieving URLs for workflow.
     * @constructor
     */
    function Manager() {}

    _.extend(Manager.prototype, {

        /**
         * Resolves the REST API URL for the workflow in a particular project.
         *
         * @param {string} options.projectKey
         * @param {string} options.workflowName
         * @returns {string} A URL.
         */
        projectWorkflow: function projectWorkflow(options) {
            return WorkflowTemplates.Urls.projectWorkflow(parseOptions(options));
        },

        /**
         * Resolves the View Workflow URL
         *
         * @param {JIRA.ProjectConfig.IssueTypes.Entities.Project|string} options.project the project or its key
         * @param {JIRA.ProjectConfig.IssueTypes.Entities.Workflow|string} options.workflow the workflow or its name
         * @returns {String} the View Workflow URL that represents this project key and workflow
         */
        viewWorkflow: function viewWorkflow(options) {
            return WorkflowTemplates.Urls.viewWorkflow(parseOptions(options));
        },

        /**
         * Resolves the Edit Workflow URL
         *
         * @param {JIRA.ProjectConfig.IssueTypes.Entities.Project|string} options.project the project or its key
         * @param {JIRA.ProjectConfig.IssueTypes.Entities.Workflow|string} options.workflow the workflow or its name
         * @returns {String} the Edit Workflow URL that represents this project key and workflow
         */
        editWorkflow: function editWorkflow(options) {
            return WorkflowTemplates.Urls.editWorkflow(parseOptions(options));
        },

        /**
         * The URL to the login page.
         *
         * @param {String|null} options.returnUrl
         * @returns {String}
         */
        login: function login(options) {
            return WorkflowTemplates.Urls.login({
                returnUrl: options.returnUrl
            });
        }
    });

    return Manager;
});