define('jira-project-config/project-config/urls/module', ['jira-project-config/project-config/urls/issue-types/manager', 'jira-project-config/global/js/projectconfig/modules/urls/workflow/manager'], function (IssueTypesManager, WorkflowManager) {
    "use strict";

    return function UrlsModule(module, application) {
        module.addInitializer(function () {
            var issueTypesUrlManager = new IssueTypesManager();
            var workflowManager = new WorkflowManager();

            application.reqres.setHandlers({
                "urls:issueTypes:base": {
                    callback: issueTypesUrlManager.base,
                    context: issueTypesUrlManager
                },
                "urls:issueTypes:viewWorkflow": {
                    callback: issueTypesUrlManager.viewWorkflow,
                    context: issueTypesUrlManager
                },
                "urls:issueTypes:editWorkflow": {
                    callback: issueTypesUrlManager.editWorkflow,
                    context: issueTypesUrlManager
                },
                "urls:issueTypes:viewFields": {
                    callback: issueTypesUrlManager.viewFields,
                    context: issueTypesUrlManager
                },
                "urls:issueTypes:rest:fields": {
                    callback: issueTypesUrlManager.projectIssueTypeFields,
                    context: issueTypesUrlManager
                },
                "urls:issueTypes:rest:workflow": {
                    callback: issueTypesUrlManager.projectIssueTypeWorkflow,
                    context: issueTypesUrlManager
                },

                "urls:workflows:rest:workflow": {
                    callback: workflowManager.projectWorkflow,
                    context: workflowManager
                },
                "urls:workflows:viewWorkflow": {
                    callback: workflowManager.viewWorkflow,
                    context: workflowManager
                },
                "urls:workflows:editWorkflow": {
                    callback: workflowManager.editWorkflow,
                    context: workflowManager
                },
                "urls:workflows:login": {
                    callback: workflowManager.login,
                    context: workflowManager
                }
            });
        });

        module.addFinalizer(function () {
            application.reqres.removeHandler("urls:issueTypes:base");
            application.reqres.removeHandler("urls:issueTypes:viewWorkflow");
            application.reqres.removeHandler("urls:issueTypes:editWorkflow");
            application.reqres.removeHandler("urls:issueTypes:viewFields");
            application.reqres.removeHandler("urls:issueTypes:rest:fields");
            application.reqres.removeHandler("urls:issueTypes:rest:workflow");

            application.reqres.removeHandler("urls:workflows:rest:workflow");
            application.reqres.removeHandler("urls:workflows:viewWorkflow");
            application.reqres.removeHandler("urls:workflows:editWorkflow");
            application.reqres.removeHandler("urls:workflows:login");
        });
    };
});