AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:urls-module"], function () {
    "use strict";

    var Backbone = JIRA.ProjectConfig.Backbone;

    module("JIRA.ProjectConfig.Urls.IssueTypes.Manager", {
        setup: function setup() {
            this.manager = new JIRA.ProjectConfig.Urls.IssueTypes.Manager();
            this.functionsToRun = [this.manager.base, this.manager.viewWorkflow, this.manager.editWorkflow, this.manager.viewFields];
        }
    });

    test("functions not HTML encoding variables", 8, function () {
        var issueType = new Backbone.Model({
            id: "<id><not><escaped>"
        });

        var project = new Backbone.Model({
            key: "<projectKey></projectKey><not><escaped>"
        });

        for (var i = 0; i < this.functionsToRun.length; i++) {
            var url = this.functionsToRun[i].call(this.manager, {
                project: project,
                issueType: issueType,
                screenType: "screenName/should/be/escaped"
            });

            ok(url.indexOf("&lt") === -1, "Should contain not HTML encoded project key.");
            ok(url.indexOf("&gt") === -1, "Should contain not HTML encoded issue type id.");
        }
    });
});