define('jira-project-config/project-config/default/module', ['jira-project-config/project-config/default/controller', 'underscore'], function (DefaultController, _) {
    "use strict";

    return function DefaultModule(module, application) {
        module.addInitializer(function () {
            var controller = new DefaultController({ application: application });
            application.vent.on("issueTypes:issueTypeSelected", _.bind(controller.selectIssueType, controller));
            application.vent.on("issueTypes:summarySelected", _.bind(controller.selectSummary, controller));
        });

        module.addFinalizer(function () {
            application.vent.off("issueTypes:issueTypeSelected");
            application.vent.off("issueTypes:summarySelected");
        });
    };
});

AJS.namespace('JIRA.ProjectConfig.Default.Module', null, require('jira-project-config/project-config/default/module'));