define('jira-project-config/project-config/default/controller', ['jira-project-config/issuetypes/navigation/controller', 'jira-project-config/marionette'], function (IssueTypesNavigationController, Marionette) {
    "use strict";

    return Marionette.Controller.extend({
        initialize: function initialize(options) {
            this.application = options.application;
            this.navigation = new IssueTypesNavigationController({
                region: this.application.issueTypesSideNav,
                reqres: this.application.reqres
            });
            this.navigation.show();
        },

        selectIssueType: function selectIssueType(value) {
            this.navigation.selectIssueType(value);
        },

        selectSummary: function selectSummary() {
            this.navigation.selectSummary();
        }
    });
});

AJS.namespace('JIRA.ProjectConfig.Default.Controller', null, require('jira-project-config/project-config/default/controller'));