require(['jira/ajs/dropdown/dropdown', 'jira/ajs/layer/layer-constants', 'jira/toggleblock/toggle-block', "jira-project-config/application", "jira-project-config/issuetypes/entities/module", 'jira-project-config/project-config/default/module', "jira-project-config/project-config/urls/module", "jira-project-config/error/module", "aui/inline-dialog", "jira/libs/parse-uri", 'jira/util/strings', "jquery"], function (Dropdown, LayerConstants, ToggleBlock, Application, EntitiesModule, DefaultModule, UrlsModule, ErrorModule, AuiInlineDialog, parseUri, strings, $) {
    "use strict";

    $(function () {

        var $operations = $(".aui-toolbar");

        $("a.project-config-inlinedialog-trigger").each(function () {
            new AuiInlineDialog($(this), "project-config-inlinedialog-" + strings.escapeHtml(parseUri(this.href).queryKey.fieldId), this.href, {
                width: 200
            });
        });

        // we are using AUI tabs classes for CSS but get the Javascript behaviour also. Removing JavaScript AJS-638
        $(".tabs-menu a").unbind("click");

        var dropdown = new Dropdown({
            trigger: $operations.find(".aui-dd-trigger"),
            content: $operations.find(".aui-list"),
            alignment: LayerConstants.RIGHT
        });

        var operationsMenuState = "closed";

        $(dropdown).bind({
            "showLayer": function showLayer() {
                operationsMenuState = "open";
            },
            "hideLayer": function hideLayer() {
                operationsMenuState = "closed";
            }
        });

        dropdown.trigger().bind("mouseenter focus", function () {
            if (operationsMenuState === "willopen") {
                dropdown.show();
            }
        });

        var blockSelector = '.project-config-scheme-item';

        new ToggleBlock({
            blockSelector: blockSelector,
            triggerSelector: ".project-config-toggle,.expander-icon",
            persist: false
        });

        $(blockSelector).on({
            'expandBlock': function expandBlock() {
                $(this).find('.expander-icon').removeClass('aui-iconfont-collapsed').addClass('aui-iconfont-expanded');
            },
            'contractBlock': function contractBlock() {
                $(this).find('.expander-icon').removeClass('aui-iconfont-expanded').addClass('aui-iconfont-collapsed');
            }
        });

        // Because of some gnarly conditional use of requireResource on the server,
        // this module may or may not exist, and apparently the whole app is fine with that.
        var IssueTypesModule = undefined;
        try {
            IssueTypesModule = require("jira-project-config/issuetypes/module");
        } catch (e) {
            // we're apparently fine with this for now...
        }

        try {
            var WorkflowModule = require("jira-project-config/workflow/module");
        } catch (e) {
            // we're apparently fine with this for now...
        }

        Application.module("Urls", UrlsModule);
        // Register IssueTypes.Entities before IssueTypes. This takes advantage of
        // Marionette's "if blank, create an empty module here" behaviour
        Application.module("IssueTypes.Entities", EntitiesModule);
        Application.module("Error", ErrorModule);
        Application.module("IssueTypes", IssueTypesModule);
        Application.module("Default", DefaultModule);
        Application.module("Workflow", WorkflowModule);

        Application.start();
    });
});