/**
 * @note this cannot be converted to an async require because JIRA's event bus
 * is not a queue, so if you miss the event subscription, it's gone.
 */
(function () {
    "use strict";

    var $ = require("jquery");
    var RestfulTable = require('aui/restful-table');
    var Events = require("jira/util/events");
    var FormDialog = require("jira/dialog/form-dialog");

    Events.bind(RestfulTable.Events.SERVER_ERROR, function (e, data) {

        var serverErrorConsole = $("#project-config-error-console");

        if (data && data.errorMessages) {

            // Replace any pre-existing messages
            serverErrorConsole.empty();

            new FormDialog({
                id: "server-error-dialog",
                content: function content(callback) {
                    callback(JIRA.Templates.Common.serverErrorDialog({
                        message: data.errorMessages[0]
                    }));
                }
            }).show();
        }
    });
})();