define('jira-project-config/global/components/userandgrouppicker/user-and-group-picker-item', ['jquery', 'jira/field/multi-user-list-picker/item', 'jira/util/strings'], function (jQuery, MultiUserListPickerItem, strings) {
    'use strict';

    return MultiUserListPickerItem.extend({
        _renders: {
            "item": function item() {
                var descriptor = this.options.descriptor;
                var data;
                var meta;

                if (descriptor.noExactMatch() !== true) {
                    meta = descriptor.meta() || {};
                    // A user or group selected from the matches
                    if (meta.isUser) {
                        data = {
                            escape: false,
                            username: meta.username,
                            icon: descriptor.icon(),
                            displayName: strings.escapeHtml(descriptor.label())
                        };
                        return jQuery(JIRA.Templates.Fields.recipientUsername(data));
                    } else if (meta.isGroup) {
                        data = {
                            escape: false,
                            groupName: descriptor.value(),
                            groupDisplayname: strings.escapeHtml(descriptor.label())
                        };
                        return jQuery(JIRA.Templates.Global.Components.UserAndGroupPickerItem.selectedGroup(data));
                    }
                }
            }
        }
    });
});