define("jira-project-config/custom-fields/views/type-item", ['jira-project-config/custom-fields/templates', "jira-project-config/marionette"], function (CustomFieldTemplates, Marionette) {
    "use strict";

    var TEMPLATES = CustomFieldTemplates;

    /**
     * A view for a single item in the types collection view.
     */
    return Marionette.ItemView.extend({
        className: "item",

        submit: function submit() {
            this.select();
            this.triggerMethod("submit", this.getKey());
        },

        events: {
            "click": "onClick",
            "dblclick": "onDoubleClick"
        },

        onClick: function onClick(event) {
            this.triggerMethod("select");
            event.preventDefault();
        },

        onDoubleClick: function onDoubleClick(event) {
            this.submit();
            event.preventDefault();
        },

        reveal: function reveal() {
            var padding = 40;
            this.$el.scrollIntoViewForAuto({
                direction: "vertical",
                marginBottom: padding,
                marginTop: padding
            });
        },

        select: function select() {
            this.$el.toggleClass("selected", true);
            this.reveal();
        },

        deselect: function deselect() {
            this.$el.toggleClass("selected", false);
        },

        tagName: "li",

        template: function template(serializedModel) {
            return TEMPLATES.type({ type: serializedModel });
        },
        getKey: function getKey() {
            return this.model.get('key');
        }
    });
});

AJS.namespace("JIRA.Admin.CustomFields.TypeItemView", null, require("jira-project-config/custom-fields/views/type-item"));