AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){"use strict";var e=require("jira-project-config/custom-fields/views/forms/form"),t=require("jquery"),i=require("underscore"),r=e.Fields.FormField.extend({initialize:function(t){this.parent=e.Fields.FormField.prototype,this.parent.initialize.call(this,t||{})},value:function(){return arguments.length?(this._value=arguments[0],this):this._value},setError:function(e){this._error=e},clearError:function(){delete this._error},error:function(){return this._error}});module("JIRA.Admin.CustomFields.Form.Validators",{setup:function(){this.sandbox=sinon.sandbox.create()},teardown:function(){this.sandbox.restore()}}),test("always",function(){var t=e.Validators.always();ok(t(),"Always should always validate.")}),test("notEmpty no error",function(){var t=(new r).value(20);e.Validators.notEmpty("Error").call(t),ok(!t.error(),"Error not set?")}),test("notEmpty error",function(){var t=new r({});e.Validators.notEmpty("Error").call(t),equal(t.error(),"Error","Error set?")}),module("JIRA.Admin.CustomFields.Form.Fields.NamedFieldMixin",{setup:function(){this.sandbox=sinon.sandbox.create(),this.Field=r.extend({mixin:[e.Fields.NamedFieldMixin]})},teardown:function(){this.sandbox.restore()}}),test("showRelevantErrors",function(){var e=new this.Field({name:"name"});ok(e.showRelevantErrors({name:"Error"}),"Shown error?"),equal(e.error(),"Error","Correct error show?"),ok(!e.showRelevantErrors({other:"Errors"}),"Ignored errors."),ok(!e.error(),"Previous error cleared?")}),test("addValueToData",function(){var e=new this.Field({name:"name"});e.value(20);var t={};e.addValueToData(t),deepEqual(t,{name:20},"Data pulled from field?"),e.value(void 0),t={},e.addValueToData(t),deepEqual(t,{},"Data ignored?"),e.value(null),t={name:"Random"},e.addValueToData(t),deepEqual(t,{name:"Random"},"Data ignored?")}),module("JIRA.Admin.CustomFields.Form.Fields.ValidatorMixin",{setup:function(){this.sandbox=sinon.sandbox.create(),this.Field=r.extend({mixin:[e.Fields.ValidatorMixin]})},teardown:function(){this.sandbox.restore()}}),test("No validator",function(){var e=new this.Field({name:"name"});ok(e.validate(),"No validator always validates?")}),test("With validator",function(){var e=this.sandbox.stub(),t=new this.Field({validator:e});e.returns(!1),ok(!t.validate(),"Validate method failed when validator failed?"),ok(e.calledOnce,"Validator called"),ok(e.firstCall.calledOn(t),"Called with field as this?"),e.returns(!0),ok(t.validate(),"Validate method passes when validator failed?"),ok(e.calledTwice,"Validator called"),ok(e.secondCall.calledOn(t),"Called with field as this?")});var l=function(e){this.$el=e};i.extend(l.prototype,{submit:function(){this.$el.submit()}});var a=function(e){this.$el=e};i.extend(a.prototype,{value:function(){return arguments.length>0?(this.$el.val(arguments[0]),this):this.$el.val()},label:function(){return this.$el.siblings().filter("label").text()},error:function(){return this.$el.siblings().filter("div.error").text()},id:function(){return this.$el.attr("id")},enabled:function(){return!this.$el.prop("disabled")},disable:function(){return this.$el.prop("disabled",!0),this},enable:function(){return this.$el.prop("disabled",!1),this},isLong:function(){return this.$el.hasClass("long-field")}});var o=function(){a.apply(this,arguments)};i.extend(o.prototype,a.prototype,{maxLength:function(){return this.$el.attr("maxLength")||0},isTextField:function(){return this.$el.is("input")&&"text"===this.$el.prop("type")}});var d=function(){a.apply(this,arguments)};i.extend(d.prototype,a.prototype,{cols:function(){return this.$el.attr("cols")||0},isTextArea:function(){return this.$el.is("textarea")}}),module("JIRA.Admin.CustomFields.Form",{setup:function(){this.sandbox=sinon.sandbox.create(),this.Field=r.extend({mixin:[e.Fields.ValidatorMixin,e.Fields.NamedFieldMixin]}),this.$fixture=t("#qunit-fixture"),t(document).focus()},teardown:function(){t(document).focus(),this.sandbox.restore()}});var n=function(e){var t=e.fieldParsers[0],i=e.fieldParsers[1],r=e.formFields[0],l=e.formFields[1],a=e.validator;l.setError("Error"),equal(i.error(),"Error","Field has correct error"),l.clearError(),ok(!i.error(),"Field no longer has error");var o={field1:"Error",field2:"Error2"},d=["global"];ok(l.showRelevantErrors(o,d)),equal(i.error(),"Error2","Field rendered errors."),deepEqual(o,{field1:"Error"},"Removed errors that were displayed."),deepEqual(d,["global"],"Did not touch global errors."),o={field1:"Error"},ok(!l.showRelevantErrors(o,d)),ok(!i.error(),"Field removed errors."),deepEqual(o,{field1:"Error"},"Did not touch field errors."),deepEqual(d,["global"],"Did not touch global errors."),l.disable(),ok(!i.enabled(),"Disabled the field?"),l.enable(),ok(i.enabled(),"Enabled the field?"),ok(!r.isDirty(),"The field should not be dirty."),r.value("something"),ok(r.isDirty(),"The field should be dirty."),equal(t.value(),"something","Value of the field correctly set."),equal(r.value(),"something","Value correctly returned."),ok(!r.value("").isDirty(),"The field should no longer be dirty."),ok(r.validate(),"Field with no validator should always validate"),ok(!l.validate(),"Field should delegate to the validator."),ok(a.calledOnce,"Validator called through the field."),ok(a.calledOn(l),"Validator called with correct scope."),ok(l.value(" something ")===l,"SetValue returns field."),equal(i.value()," something ","Value set correctly."),equal(l.value(),"something","Value returned correctly."),ok(l.value("  ")===l,"SetValue returns field."),equal(i.value(),"  ","Value set correctly."),equal(l.value(),"","Value returned correctly."),i.value("");var n={};l.addValueToData(n),deepEqual(n,{},"Empty field does not add data."),i.value("   "),l.addValueToData(n),deepEqual(n,{},"Empty field does not add data."),i.value("sadjads   \t\n"),l.addValueToData(n),deepEqual(n,{field2:"sadjads"},"Empty field does not add data.")};test("text field ",function(){var t=this.sandbox.stub(),i=new e({fields:[{id:"field1",type:"text",label:"Field 1"},{id:"field2",type:"text",label:"Field 2",maxLength:255,validator:t,size:e.Fields.FormField.SIZE.large}]});this.$fixture.html(i.render().$el);var r=new o(this.$fixture.find("#field1")),l=new o(this.$fixture.find("#field2"));equal(r.label(),"Field 1","Correct label?"),equal(r.id(),"field1","Correct Id?"),equal(r.maxLength(),0,"Correct maxlength?"),equal(r.value(),"","Field should be empty?"),ok(r.enabled(),"Field should be enabled?"),ok(!r.isLong(),"Field should not be long?"),ok(r.isTextField(),"Should be a text field"),equal(l.label(),"Field 2","Correct label?"),equal(l.id(),"field2","Correct Id?"),equal(l.maxLength(),255,"Correct maxlength?"),equal(l.value(),"","Field should be empty?"),ok(l.enabled(),"Field should be enabled?"),ok(l.isLong(),"Field should be long?"),ok(l.isTextField(),"Should be a text field"),n.call(this,{fieldParsers:[r,l],formFields:[i.fields.field1,i.fields.field2],validator:t})}),test("textarea field",function(){var t=this.sandbox.stub(),i=new e({fields:[{id:"field1",type:"textarea",label:"Field 1"},{id:"field2",type:"textarea",label:"Field 2",cols:10,validator:t,size:e.Fields.FormField.SIZE.large}]});this.$fixture.html(i.render().$el);var r=new d(this.$fixture.find("#field1")),l=new d(this.$fixture.find("#field2"));equal(r.label(),"Field 1","Correct label?"),equal(r.id(),"field1","Correct Id?"),equal(r.cols(),0,"Correct maxlength?"),equal(r.value(),"","Field should be empty?"),ok(r.enabled(),"Field should be enabled?"),ok(!r.isLong(),"Field should not be long?"),ok(r.isTextArea(),"Field is text area"),equal(l.label(),"Field 2","Correct label?"),equal(l.id(),"field2","Correct Id?"),equal(l.cols(),10,"Correct maxlength?"),equal(l.value(),"","Field should be empty?"),ok(l.enabled(),"Field should be enabled?"),ok(l.isLong(),"Field should be long?"),ok(l.isTextArea(),"Field is text area"),n.call(this,{fieldParsers:[r,l],formFields:[i.fields.field1,i.fields.field2],validator:t})}),test("append field",function(){var t=this.sandbox.stub(),i=new e({fields:[{id:"field1",type:"textarea",label:"Field 1"}]});this.$fixture.html(i.render().$el);var r=i.addField({id:"field2",type:"text",label:"Field 2",validator:t,size:e.Fields.FormField.SIZE.large});ok(r===i,"this returned from form.addField");var l=new d(this.$fixture.find("#field1")),a=new o(this.$fixture.find("#field2"));equal(l.label(),"Field 1","Correct label?"),equal(l.id(),"field1","Correct Id?"),equal(l.cols(),0,"Correct maxlength?"),equal(l.value(),"","Field should be empty?"),ok(l.enabled(),"Field should be enabled?"),ok(!l.isLong(),"Field should not be long?"),ok(l.isTextArea(),"Field is text area?"),equal(a.label(),"Field 2","Correct label?"),equal(a.id(),"field2","Correct Id?"),equal(a.value(),"","Field should be empty?"),ok(a.enabled(),"Field should be enabled?"),ok(a.isLong(),"Field should be long?"),ok(a.isTextField(),"Field is text input?"),n.call(this,{fieldParsers:[l,a],formFields:[i.fields.field1,i.fields.field2],validator:t})}),test("submit on form",function(){var t=this.sandbox.stub(),i=this.sandbox.stub().returns(!1),r=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description",validator:i}]});this.$fixture.html(r.render().$el);var a=new l(this.$fixture.find("form"));r.on("submit",t),a.submit(),ok(!t.called,"Submit not called when form invalid."),i.returns(!0),a.submit(),ok(t.calledOnce,"Submit called when form valid.")}),test("submit on object",function(){var t=this.sandbox.stub(),i=this.sandbox.stub().returns(!1),r=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description",validator:i}]});this.$fixture.html(r.render().$el),r.on("submit",t),ok(r.submit()===r,"Form returns this on submit"),ok(!t.called,"Submit not called when form invalid."),i.returns(!0),r.submit(),ok(t.calledOnce,"Submit called when form valid.")}),test("validate",function(){var t=this.sandbox.stub().returns(!1),i=new e({fields:[{id:"name",type:"text",label:"Name",validator:t},{id:"description",type:"textarea",label:"Description",validator:t}]});this.$fixture.html(i.render().$el);var r=new d(this.$fixture.find("#name"));ok(!i.validate(),"Validate must fail."),r.disable(),ok(!i.validate(),"Validate must fail."),t.returns(!0),ok(i.validate(),"Validate must succeed.")}),test("showErrors",function(){var t=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]}),r=["Global Errors"],l={};this.$fixture.html(t.render().$el);var a=new d(this.$fixture.find("#name")),n=new o(this.$fixture.find("#description"));ok(!t.showErrors(l,r),"No errors rendered returns false."),l={name:"Name",description:"Description",other:"Other"};var s=i.clone(l),u=i.clone(r);ok(t.showErrors(s,u),"Some errors returns true."),deepEqual(s,{other:"Other"},"Removed errors not displayed."),deepEqual(u,r,"Didn't touch global errors."),equal(a.error(),"Name","Name field has error"),equal(n.error(),"Description","Description field has error"),l={description:"Description"},s=i.clone(l),u=i.clone(u),ok(t.showErrors(s,u),"Some errors returns true."),deepEqual(s,{},"Removed errors not displayed."),deepEqual(u,r,"Didn't touch global errors."),ok(!a.error(),"Name field error should have been removed."),equal(n.error(),"Description","Description field has error"),l={description:"Description",name:"Name"},s=i.clone(l),u=i.clone(u),t.blur(),a.disable(),ok(t.showErrors(s,u),"Some errors returns true."),deepEqual(s,{},"Removed errors not displayed."),deepEqual(u,r,"Didn't touch global errors."),equal(a.error(),"Name","Name field error should be displayed"),equal(n.error(),"Description","Description field has error"),t.blur()}),test("enable & disable",function(){var t=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(t.render().$el);var i=new d(this.$fixture.find("#name")),r=new o(this.$fixture.find("#description"));ok(i.enabled(),"The name is enabled."),ok(r.enabled(),"The description is enabled."),ok(t.disable()===t,"Form returned from disable."),ok(!i.enabled(),"The name is disabled."),ok(!r.enabled(),"The description is disabled."),ok(t.enable()===t,"Form returned from enable."),ok(i.enabled(),"The name is enabled."),ok(r.enabled(),"The description is enabled.")}),test("toJson",function(){var t=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(t.render().$el);var i=new d(this.$fixture.find("#name")),r=new o(this.$fixture.find("#description"));i.value("name"),r.value("description"),deepEqual(t.toJSON(),{name:"name",description:"description"},"Form correctly parsed."),i.value("       "),r.value("description"),deepEqual(t.toJSON(),{description:"description"},"Form correctly parsed.")}),test("isDirty",function(){var t=new e({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(t.render().$el);var i=new d(this.$fixture.find("#name")),r=new o(this.$fixture.find("#description"));ok(!t.isDirty(),"Should not be dirty."),i.value("name"),ok(t.isDirty(),"Should be dirty."),i.value(""),ok(!t.isDirty(),"Should not be dirty."),r.value("name"),ok(t.isDirty(),"Should be dirty."),i.value("name"),ok(t.isDirty(),"Should be dirty."),i.value(""),r.value(""),ok(!t.isDirty(),"Should not be dirty.")}),test("Add Field With Content",function(){var i=new e({fields:[{content:function(){return t("<div>").attr("id","test-div")}},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(i.render().$el),ok(this.$fixture.find("#test-div").length,"Added element with content.")})});