AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){"use strict";var e=require("underscore"),s=require("jira/jquery/deferred"),a=require("jira/ajs/ajax/smart-ajax"),t=require("jira/ajs/ajax/smart-ajax/web-sudo"),l=require("jira-project-config/custom-fields/service"),r=function(e){var t={},l=this.sandbox.stub(a,"buildSimpleErrorContent"),r=s(),o=this.sandbox.stub(this.api,"_ajax");l.withArgs(t).returns(e.humanErrorMessage),o.returns(r);var n=this.sandbox.stub(),d=this.sandbox.stub();this.api[e.func]("<ABC></ABC>","field").done(n).fail(d),ok(!n.called,"Success should not be called."),ok(!d.called,"Fail should not have been called until ajaxing complete."),r.reject(e.statusText,t),ok(d.calledOnce,"Fail should have been called."),deepEqual(d.firstCall.args,e.expectedErrors,"Should have failed with error and reason.")};module("JIRA.Admin.CustomFields.IssueCustomFields",{setup:function(){var s=this;this.issue="<issue></issue>",this.sandbox=sinon.sandbox.create(),this.api=new l({issue:this.issue}),this.assertError=function(t,l,r,o){var n=e.isString(t)?t:JSON.stringify(t),d={hasData:e.isUndefined(o)?!!n:o,data:n};s.sandbox.stub(a,"buildSimpleErrorContent").returns("Simple error");var i=this.api._parseErrorCollection(d,l);deepEqual(i,r)}},teardown:function(){this.sandbox.restore()}});var o=function(s){equal(s.type,"POST","AJAX call should have been a POST."),ok(s.url.match(new RegExp("/rest/api/2/field$")),"Is AJAX URL correct?"),equal(s.dataType,"json","Data type correct"),equal(s.contentType,"application/json","Data type correct"),deepEqual(JSON.parse(s.data),e.omit(JSON.parse(s.data),"random"),"AJAX call has correct body?")};test("addField creates a field (happy)",function(){var e={name:"name",description:"description",searcherKey:"searcherKey",type:"type",random:"value"},a={id:"customField"},t=this.sandbox.stub(this.api,"_ajax"),l=s(),r=this.sandbox.stub();t.returns(l.promise()),this.api.addField(e).done(r),ok(t.calledOnce,"Ajax request should have been made.");var n=t.firstCall.args[0];o(n),ok(!r.called,"done handler not called until ajax returns"),l.resolve(a),ok(r.calledOnce,"done handler called once"),ok(r.firstCall.calledWith(a),"AJAX response returned verbatim.")}),test("addField handles server error response",function(){var e={general:["error"],fields:{}},a={name:"name",description:"description",searcherKey:"searcherKey",type:"type",random:"value"},t={something:"true"},l=this.sandbox.stub(this.api,"_ajax"),r=s(),n=this.sandbox.stub(),d=this.sandbox.stub(this.api,"_parseErrorCollection").returns(e);l.returns(r.promise()),this.api.addField(a).fail(n),ok(l.calledOnce,"Ajax request should have been made.");var i=l.firstCall.args[0];o(i),ok(!n.called,"error handler not called until ajax returns"),ok(!d.called,"_parseErrorCollection not called yet."),r.reject("status text",t),ok(d.calledOnce,"Called _parseErrorCollection to deal with response."),ok(d.firstCall.calledWith(t,{fieldName:"name"}),"Called _parseErrorCollection with response."),ok(n.calledOnce,"error handler called once"),deepEqual(n.firstCall.args[0],e,"AJAX response returned verbatim.")}),test("_parseErrorCollection splits errors into field and general",function(){var e={errorMessages:["General Error"],errors:{fieldName:"name",description:"something"}},s={fieldName:"foo"};this.assertError(e,s,{general:["General Error"],fields:{foo:"name",description:"something"}})}),test("_parseErrorCollection handles only general errors",function(){var e={errorMessages:["General Error"]},s={};this.assertError(e,s,{general:["General Error"],fields:{}})}),test("_parseErrorCollection handles only field errors",function(){var e={errors:{fieldName:"name",description:"something"}},s={fieldName:"name"};this.assertError(e,s,{general:[],fields:{name:"name",description:"something"}})}),test("_parseErrorCollection handles void",function(){this.assertError({},{},{general:["Simple error"],fields:{}})}),test("_parseErrorCollection handles hasData=false (but with data)",function(){var e={errorMessages:["General Error"],errors:{fieldName:"name",description:"something"}},s={};this.assertError(e,s,{general:["Simple error"],fields:{}},!1)}),test("_parseErrorCollection handles JSON parse errors",function(){var e={};this.assertError("bro[k]en",e,{general:["Simple error"],fields:{}})}),test("Default options",function(){var e=new l;equal(e.autoCloseWebsudo,!0,"Autoclose enabled by default.")}),test("getSharedBy handles happy case",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub(),r=s(),o={a:!0,b:!1};a.returns(e),this.api.getSharedBy(r).done(t).fail(l),ok(!a.called,"Ajax should not be called until success of wrapped."),r.resolve({},1,2),ok(a.calledOnce,"Ajax should have been called once.");var n=a.firstCall.args[0];strictEqual(n.type,"GET","Ajax should be a get."),strictEqual(n.contentType,"application/json","Body should be json"),strictEqual(n.dataType,"json","Response should be json.");var d=new RegExp("/rest/globalconfig/1/issuecustomfields/"+encodeURIComponent(this.issue)+"/affectedProjects$");ok(d.test(n.url),"URL is correct and encoded."),ok(!t.called,"Success should not be called until ajax returns."),ok(!l.called,"Fail should never be called."),e.resolve(o),ok(t.calledOnce,"Success should now have been called."),ok(t.firstCall.calledWith({sharedBy:o}),"Success should just pass the arguments through.")}),test("getSharedBy delegates errors/progress in wrapper.",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub(),r=this.sandbox.stub(),o=s();a.returns(e),this.api.getSharedBy(o).done(t).fail(l).progress(r),ok(!a.called,"Ajax should not be called until success of wrapped."),o.notify("Something"),o.notify("Else",!0,1),ok(r.calledTwice,"Two progress events."),ok(r.firstCall.calledWith("Something"),"First progress event received."),ok(r.secondCall.calledWith("Else",!0,1),"Second progress event received."),o.reject({},1,2),ok(!a.called,"Ajax should not be called on error."),ok(!t.called,"Success should not be called on error."),ok(l.calledOnce,"Fail should be called."),ok(l.firstCall.calledWith({},1,2),"Fail called with correct arguments.")}),test("getSharedBy returns error cases as no projects",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub(),r=s();a.returns(e),this.api.getSharedBy(r).done(t).fail(l),ok(!a.called,"Ajax should not be called until success of wrapped."),r.resolve({},1,2),ok(a.calledOnce,"Ajax should have been called once.");var o=a.firstCall.args[0];strictEqual(o.type,"GET","Ajax should be a get."),strictEqual(o.contentType,"application/json","Body should be json"),strictEqual(o.dataType,"json","Response should be json.");var n=new RegExp("/rest/globalconfig/1/issuecustomfields/"+encodeURIComponent(this.issue)+"/affectedProjects$");ok(n.test(o.url),"URL is correct and encoded."),ok(!t.called,"Success should not be called until ajax returns."),ok(!l.called,"Fail should never be called."),e.reject("Something should be ignored."),ok(t.calledOnce,"Success should now have been called."),ok(t.firstCall.calledWith({sharedBy:[]}),"Success should just pass the arguments through.")}),test("getSharedBy no issue returns empty projects",function(){var e=new l,a=this.sandbox.stub(e,"_ajax"),t=this.sandbox.stub(),r=this.sandbox.stub(),o=s();e.getSharedBy(o).done(t).fail(r),o.resolve({},1,2),ok(!a.called,"Ajax is never called when no issue."),ok(t.calledOnce,"Success should now have been called."),ok(t.firstCall.calledWith({sharedBy:[]}),"Success should just pass the arguments through."),ok(!r.called,"Fail should never be called.")}),test("addFieldToScreen handles happy case",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub();a.returns(e),this.api.addFieldToScreen("field").done(t).fail(l),ok(a.calledOnce,"Ajax should have been called once.");var r=a.firstCall.args[0];strictEqual(r.type,"POST","Ajax should be a post."),strictEqual(r.data,"field","Body should be the field name."),strictEqual(r.contentType,"application/json","Body should be json"),strictEqual(r.dataType,"json","Response should be json.");var o=new RegExp("/rest/globalconfig/1/issuecustomfields/"+encodeURIComponent(this.issue)+"$");ok(o.test(r.url),"URL is correct and encoded."),ok(!t.called,"Success should not be called until ajax resturns."),ok(!l.called,"Fail should never be called."),e.resolve(1,2,3,"four"),ok(t.calledOnce,"Success should now have been called."),ok(t.firstCall.calledWith(1,2,3,"four"),"Success should just pass the arguments through.")}),test("addFieldToScreen handles happy case no issue",function(){var e=new l,s=this.sandbox.stub(e,"_ajax"),a=this.sandbox.stub(),t=this.sandbox.stub();e.addFieldToScreen("field").done(a).fail(t),ok(!s.called,"AJAX not called."),ok(!a.called,"Success should not be called."),ok(t.calledOnce,"Fail should be called.")}),test("addFieldToScreen handles error",function(){r.call(this,{func:"addFieldToScreen",statusText:"error",humanErrorMessage:"Error",expectedErrors:[l.STATUS.error,"Error"]})}),test("addFieldToScreen handles abort",function(){r.call(this,{func:"addFieldToScreen",statusText:"abort",expectedErrors:[l.STATUS.abort,null]})}),test("getCustomFieldsTypes handles successful AJAX",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub();a.returns(e),this.api.getCustomFieldTypes().done(t).fail(l),ok(a.calledOnce,"Ajax should have been called once.");var r=a.firstCall.args[0];strictEqual(r.type,"GET","Ajax should be a GET."),strictEqual(r.contentType,"application/json","Body should be json"),strictEqual(r.dataType,"json","Response should be json.");var o=new RegExp("/rest/globalconfig/1/customfieldtypes$");ok(o.test(r.url),"URL is correct and encoded."),ok(!t.called,"Success should not be called until ajax resturns."),ok(!l.called,"Fail should never be called.");e.resolve(1,2,3),ok(t.calledOnce,"Success should now have been called."),strictEqual(t.firstCall.args[0],1,"Success should just pass the arguments through.")}),test("getCustomFieldsTypes handles error",function(){r.call(this,{func:"getCustomFieldTypes",statusText:"error",humanErrorMessage:"Error",expectedErrors:[l.STATUS.error,"Error"]})}),test("getCustomFieldsTypes handles abort",function(){r.call(this,{func:"getCustomFieldTypes",statusText:"abort",expectedErrors:[l.STATUS.abort,null]})}),test("setOptions handles successful AJAX",function(){var e=s(),a=this.sandbox.stub(this.api,"_ajax"),t=this.sandbox.stub(),l=this.sandbox.stub();a.returns(e);var r=[{name:"Name"}];this.api.setOptions("<fieldId>",r).done(t).fail(l),ok(a.calledOnce,"Ajax should have been called once.");var o=a.firstCall.args[0];strictEqual(o.type,"POST","Ajax should be a POST."),strictEqual(o.contentType,"application/json","Body should be json"),strictEqual(o.dataType,"json","Response should be json."),strictEqual(o.data,JSON.stringify(r));var n=new RegExp("rest/globalconfig/1/customfieldoptions/"+encodeURIComponent("<fieldId>")+"$");ok(n.test(o.url),"URL is correct and encoded."),ok(!t.called,"Success should not be called until ajax resturns."),ok(!l.called,"Fail should never be called.");e.resolve(1,2,3),ok(t.calledOnce,"Success should now have been called."),strictEqual(t.firstCall.args[0],1,"Success should just pass the arguments through.")}),test("setOptions handles error",function(){r.call(this,{func:"setOptions",statusText:"error",humanErrorMessage:"Error",expectedErrors:[l.STATUS.error,"Error"]})}),test("setOptions handles abort",function(){r.call(this,{func:"setOptions",statusText:"abort",expectedErrors:[l.STATUS.abort,null]})});var n=function(e,a){var r=this.sandbox.stub(),o=this.sandbox.stub(),n=this.sandbox.stub(),d=s(),i=this.sandbox.stub(t,"makeWebSudoRequest");i.returns(d);var c={some:"random",options:!0};this.api._ajax(c).done(o).fail(n).progress(r),ok(i.calledOnce,"Called the ajax provider");var u=i.getCall(0);deepEqual(c,u.args[0],"Passing through the AJAX options?");var h=u.args[1];ok(h.beforeShow,"Passed in beforeShow trigger."),ok(h.success,"Passed in success trigger."),ok(!r.called,"Making sure beforeShow not called yet!"),h.beforeShow(),ok(r.calledOnce,"Making sure beforeShow called now"),deepEqual(r.firstCall.args,[l.PROGRESS.SHOW],"Making sure beforeShow with correct progress.");var p=function(){};ok(!o.called,"Making sure success not called yet!"),h.success(p),ok(r.calledTwice,"notified of websudo success"),deepEqual(r.secondCall.args,[l.PROGRESS.SUCCESS,p],"Correct callback?"),ok(!o.called,"Done should not be called until AJAX returned."),ok(!n.called,"Cancel should not be called until AJAX returned."),a(d,h.cancel,o,n)},d=function(e){n.call(this,e,function(e,s,a,t){e.resolve(1,2,3),ok(a.called,"Done called once ajax completes."),strictEqual(a.firstCall.args[0],1,"Done receives data from response."),ok(!t.called,"Failed should not have been called.")})},i=function(e){n.call(this,e,function(e,s,a,t){e.reject(e,2,3,4),ok(t.called,"failed called when ajax completes."),deepEqual(t.firstCall.args,[2,4],"fail called with correct arguments."),ok(!a.called,"Done should not have been called.")})},c=function(e){n.call(this,e,function(e,s,a,t){var l=AJS.$.Event("cancel");s(l),ok(l.isDefaultPrevented(),"Cancel prevents default."),ok(t.calledOnce,"Cancel calls fail."),ok(t.firstCall.calledWith("abort",void 0),"Cancel fails like an abort."),ok(!a.called,"Dont should not be called on success.")})};test("ajax delegates to smart AJAX success",function(){d.call(this,this.step)}),test("ajax delegates to smart AJAX failed",function(){i.call(this,this.step)}),test("smart AJAX websudo cancel aborts the wizard",function(){c.call(this,this.step)})});