define("jira-project-config/component/view/delete-form", ['jira-project-config/component/templates', "jira-project-config/backbone", "jquery"], function (ComponentTemplates, Backbone, $) {
    "use strict";

    var TEMPLATES = ComponentTemplates;
    /**
     * Renders and handles submission of delete form used in dialog
     */
    return Backbone.View.extend({

        /**
         * Destorys model on server
         *
         * @param {Object} values
         * @param complete
         * @return {JIRA.Admin.Version.DeleteForm}
         */
        submit: function submit(values, row, complete) {

            this.$(".throbber").addClass("loading");

            if (values.component !== "swap") {
                delete values.moveIssuesTo;
            }

            this.model.destroy({
                data: values,
                success: function success() {
                    complete();
                },
                error: function error() {
                    complete();
                }
            });

            return this;
        },

        /**
         * Renders delete form. This differs from standard render methods, as it requires async request/s to the server.
         * As a result when this method is calle the first argument is a function that is called when the content has been
         * rendered.
         *
         * @param {function} ready - callback to declare content is ready
         * @return {JIRA.Admin.Version.DeleteForm}
         */
        render: function render(ready) {

            var instance = this;

            this.model.getRelatedIssueCount({
                success: function success(relatedIssueCount) {
                    instance.el.innerHTML = TEMPLATES.deleteForm({
                        relatedIssueCount: relatedIssueCount,
                        component: instance.model.toJSON(),
                        swapComponents: instance.model.getSwapComponentsJSON(),
                        projectId: $("meta[name=projectId]").attr("content")
                    });

                    ready.call(instance, instance.el);
                }
            });

            return this;
        }
    });
});

AJS.namespace("JIRA.Admin.Component.DeleteForm", null, require("jira-project-config/component/view/delete-form"));