define("jira-project-config/application", ["jira-project-config/utils/virtual-region", "jira-project-config/utils/region", "wrm/data", "jira/util/data/meta", "wrm/context-path", "jira-project-config/backbone", "jira-project-config/marionette"], function (VirtualRegion, Region, wrmData, Meta, contextPath, Backbone, Marionette) {
    "use strict";

    // Contains static data such as projectKey.

    var appData = wrmData.claim("com.atlassian.jira.jira-project-config-plugin:app-data");

    /**
     * The application used by the project administration.
     * @name JIRA.ProjectConfig.Application
     * @type Marionette.Application
     * @static
     */
    var application = new Marionette.Application();

    /**
     * Returns a backbone model representing the project being viewed
     */
    application.reqres.setHandler("projectKey", function () {
        return appData.projectKey;
    });

    /**
     * Change the title of the window.
     *
     * This method appends the JIRA app title suffix to `title`.
     * @param {string} text The new title of the page (excluding JIRA app title).
     */
    application.title = function (text) {
        document.title = text + " - " + Meta.get("app-title");
    };

    application.addRegions({
        issueTypesSideNav: new VirtualRegion({
            el: "#content .admin-menu-links:visible",
            target: "#project_issuetypes"
        }),
        content: {
            selector: "section.aui-page-panel-content",
            regionType: Region
        }
    });

    application.on("initialize:after", function () {
        // Retrieve the hash before starting history, otherwise the route on the path will be triggered,
        // which will replace the hash (meaning we can't navigate to the hash route).

        Backbone.history.start({
            hashChange: true,
            pushState: window.history.pushState,
            root: contextPath() + "/"
        });
    });

    return application;
});

AJS.namespace('JIRA.ProjectConfig.Application', null, require('jira-project-config/application'));