/**
 * @module quick-edit/form/error/create-issue
 */
define('quick-edit/form/error/create-issue', [
    'quick-edit/form/error',
    'quick-edit/templates/issue',
    'jquery'
], function(
    Error,
    IssueTemplates,
    jQuery
){
    'use strict';

    /**
     * Renders an error message with create issue furniture
     *
     * @class CreateIssueFormError
     * @extends FormError
     */
    return Error.extend({
        _render: function (error) {
            return jQuery(IssueTemplates.createIssueError({
                errorHtml: error
            }));
        }
    });
});

/**
 * @deprecated JIRA.Forms.CreateIssueError
 */
AJS.namespace('JIRA.Forms.CreateIssueError', null, require('quick-edit/form/error/create-issue'));

