/**
 * @module quick-edit/form/abstract/unconfigurable
 */
define('quick-edit/form/abstract/unconfigurable', [
    'quick-edit/form/abstract',
    'quick-edit/templates/issue',
    'jquery'
], function(
    AbstractForm,
    IssueTemplates,
    jQuery
){
    'use strict';

    /**
     * A View class that renders a form that cannot be configured.
     *
     * @class AbstractUnconfigurableForm
     * @extends AbstractForm
     */
    return AbstractForm.extend({
        /**
         * Gets HTML for fields. This includes tabs and tab panes if applicable.
         *
         * @return jQuery.Deferred
         */
        getFieldsHtml: function () {
            var instance = this,
                deferred = jQuery.Deferred(),
                data = {};

            this.model.getTabs().done(function (tabs) {
                if (tabs.length === 1) {
                    data.fields = tabs[0].fields;

                } else {
                    data.tabs = tabs;
                    data.hasTabs = true;
                }

                deferred.resolveWith(instance, [IssueTemplates.issueFields(data)]);

            });

            return deferred.promise();
        },

        /**
         * Gets ids for all fields
         *
         * @return {Array}
         */
        getActiveFieldIds: function () {
            var ids = [];

            this.model.getFields().done(function (fields) {
                jQuery.each(fields, function (i, field) {
                    ids.push(field.id);
                });
            });

            if (ids.indexOf("attachment")) {
                var fileToConvertIds = this.$element.find('input[name=filetoconvert]').map(function(idx, el) { return el.id }).toArray();
                ids.push.apply(ids, fileToConvertIds);
            }

            return ids;
        },

        /**
         * Gets all fields
         *
         * @param Array<ConfigurableField> fields
         * @return jQuery Promise
         */
        getFields: function () {
            var deferred = jQuery.Deferred(),
                instance = this;

            if (!this.fields) {
                this.fields = [];

                this.model.getFields().done(function (fields) {
                    jQuery.each(fields, function (i, descriptor) {
                        var field = instance.createField(descriptor);
                        instance.fields.push(field);

                    });
                    deferred.resolveWith(instance, [instance.fields]);
                });
            } else {
                deferred.resolveWith(this, [this.fields]);
            }

            return deferred.promise();
        }

    });
});

/**
 * @deprecated JIRA.Forms.AbstractUnconfigurableForm
 */
AJS.namespace('JIRA.Forms.AbstractUnconfigurableForm', null, require('quick-edit/form/abstract/unconfigurable'));