define('jira/admin-helper/notification-helper/content-loader', [
    'jquery',
    'jira/admin-helper/context',
    'jira/admin-helper/notification-helper/ui'
], function (
    $,
    Context,
    HelperUi
) {
    return {
        loadContent: function loadContent(dialog, callback) {
            var currentIssueKey = createViewContext().issueKey() || '';

            AJS.trigger('analyticsEvent', {
                name: 'adminhelper.notihelper.dialog.open',
                data: {
                    issueKeyPresent: currentIssueKey != '',
                    onEditNotificationsPage: $("#notificationSchemeTable").length > 0,
                    onViewNotificationsPage: $("#project-config-notifications-table").length > 0
                }
            });

            dialog.addHeading(AJS.I18n.getText("adminhelper.dialog.notification.title"));
            dialog.onContentReady(function onContentReady() {
                HelperUi.initUi(dialog.get$popupContent(), createViewContext(), function () {
                    dialog._positionInCenter();
                });
            });

            callback($(JIRA.Templates.Dialogs.NotificationHelper.searchPage({
                currentIssueKey: currentIssueKey,
                events: HelperUi.NOTIFICATION_EVENTS,
                defaultEventId: HelperUi.defaultEventId()
            })));

            function createViewContext() {
                var issueKey = JIRA.Issue.getIssueKey();
                if (!issueKey && JIRA.IssueNavigator) {
                    issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
                }
                return new Context({
                    issueKey: issueKey
                });
            }
        }
    }
});