define('jira/project-templates/select-project-template-controller', [
    'jira/project-templates/select-project-template-view',
    'jira/project-templates/template-info-controller',
    'jira/project-templates/add-project-controller',
    'jira/project-templates/dialog-controller',
    'jira/project-templates/dialog-view',
    'jira/project-templates/config',
    'wrm/context-path',
    'jquery',
    'underscore'
], function(
    SelectProjectTemplateView,
    TemplateInfoController,
    AddProjectController,
    DialogController,
    DialogView,
    Config,
    ContextPath,
    $,
    _
){
    var contextPath = ContextPath();
    var SelectProjectTemplateController = {
        init: function init(data, projectTypeKey) {
            SelectProjectTemplateView.draw(data, projectTypeKey);
        },

        /**
         * Returns true if project types have been enabled on the server.
         * @param data the model returned by the server
         * @returns {boolean} true if project types have been enabled on the server.
         */
        isProjectTypesEnabled: function isProjectTypesEnabled(data) {
            return data.projectTemplatesGroupedByType != null;
        },

        /**
         * Return a Promise that others can hook into that returns the data required.
         */
        loadProjectTemplatesData: function loadProjectTemplatesData() {
            // Perform AJAX request for web items in the dialog and return them.
            return $.ajax({
                url: contextPath + "/rest/project-templates/1.0/templates",
                type: "GET"
            });
        },

        loadDemoProjectTemplatesData: function loadProjectTemplatesData() {
            // Perform AJAX request for web items in the dialog and return them.
            return $.ajax({
                url: contextPath + "/rest/project-templates/1.0/templates/demo-projects",
                type: "GET"
            }).then(function(result) {
                result.demoProjects = true;
                return result;
            });
        },

        dialogSubmitted: function dialogSubmitted() {
            var projectTemplateData = SelectProjectTemplateView.getSelectedTemplateData();

            DialogController.hideDialogFromNewUser("templateselected");

            SelectProjectTemplateController.raiseAtlassianEvent(projectTemplateData.itemModuleCompleteKey);

            if (!_.isUndefined(projectTemplateData.infoSoyPath)) {
                TemplateInfoController.initTemplateInfo(projectTemplateData);
            } else {
                SelectProjectTemplateController.openAddProjectPage(projectTemplateData);
            }
        },

        openAddProjectPage: function openAddProjectPage(projectTemplateData) {
            if (!projectTemplateData) {
                // Null data? How did you get here? It should be impossible to have no selected item.
                DialogView.showErrorMessage(AJS.I18n.getText("add.projects.templates.error.requestfailed.msg"));
                return;
            }

            // Should the template key be missing, go to the project configuration step
            if (projectTemplateData.createProject) {
                AddProjectController.initProjectTemplate(projectTemplateData);
                // Otherwise, no template key provided: fire an event passing the dialog, so the plugin can choose what to do next
            } else {
                DialogController.dialog.addPage("blank-template-page");
                $("body").trigger(projectTemplateData.itemModuleCompleteKey, DialogController.dialog);
            }
        },

        raiseAtlassianEvent: function raiseAtlassianEvent(projectTemplateModuleKey) {
            Config.model.selectedTemplate = projectTemplateModuleKey;
            if (AJS.EventQueue) {
                AJS.EventQueue.push({
                    name: "projecttemplates.templateselected",
                    properties: {
                        selectedTemplate: projectTemplateModuleKey
                    }
                });
            }
        }
    };
    return SelectProjectTemplateController;
});
AJS.namespace('JPT.SelectProjectTemplateController', null, require('jira/project-templates/select-project-template-controller'));
