var $ = require('jquery');
$(function () {

    var format = AJS.format;
    var AddProjectController = require('jira/project-templates/add-project-controller');

    var confluenceProjectLink = localStorage.getItem(AddProjectController.localStoragePrefix + "confluenceProject");
    var fishEyeProjectLink = localStorage.getItem(AddProjectController.localStoragePrefix + "fisheyeProject");
    var crucibleProjectLink = localStorage.getItem(AddProjectController.localStoragePrefix + "crucibleProject");
    var bambooProjectLink = localStorage.getItem(AddProjectController.localStoragePrefix + "bambooProject");

    localStorage.removeItem(AddProjectController.localStoragePrefix + "confluenceProject");
    localStorage.removeItem(AddProjectController.localStoragePrefix + "fisheyeProject");
    localStorage.removeItem(AddProjectController.localStoragePrefix + "crucibleProject");
    localStorage.removeItem(AddProjectController.localStoragePrefix + "bambooProject");

    var message;
    function formatAnchor(link, label) {
        return JIRA.Templates.ProjectTemplates.formatAnchor({
            href: link,
            body: label,
            title: label
        });
    }
    function createProjectLinks(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink) {
        var links = [];
        links.push(AJS.I18n.getText("remote.projects.created.summary.ondemand.jira.project"));
        if (confluenceProjectLink) {
            links.push(formatAnchor(confluenceProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.confluence.project")));
        }
        if (fecruProjectLink) {
            links.push(formatAnchor(fecruProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.fisheye.project")));
        }
        if (crucibleProjectLink) {
            links.push(formatAnchor(crucibleProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.crucible.project")));
        }
        if (bambooProjectLink) {
            links.push(formatAnchor(bambooProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.bamboo.project")));
        }
        return links;
    }
    function createMessage(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink) {
        var title = AJS.I18n.getText("remote.projects.created.summary.ondemand.projects.created.title");
        var projectLinks = createProjectLinks(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink);
        var lastLink = projectLinks.pop();
        return (projectLinks.length > 0) ? format(title, projectLinks.join(", "), lastLink) : null;
    }
    function scrollTo(selector) {
        var settingsOffset = $(selector).offset();
        if (settingsOffset) {
            window.scrollTo(settingsOffset.left, settingsOffset.top);
        }
    }

    if (confluenceProjectLink || fishEyeProjectLink || crucibleProjectLink || bambooProjectLink) {
        message = createMessage(confluenceProjectLink, fishEyeProjectLink, crucibleProjectLink, bambooProjectLink);
        if (message) {
            JIRA.Messages.showSuccessMsg(message, {
                closeable:true
            });
        }
        scrollTo("#project-config-webpanel-summary-settings");
    }
});