// Warning!
//This module has a hidden circular dependency -> jira/project-templates/dialog-controller
define('jira/project-templates/dialog-view-impl', [
    'require',
    'backbone',
    'underscore'
], function(
    require,
    Backbone,
    _
){
    var Dialog = AJS.Dialog;
    var Trigger = AJS.trigger;

    return Backbone.View.extend({
        events: {
            "click   .add-project-trigger": "_onClickAddProject",
            "click   .add-demo-project-trigger": "_onClickAddDemoProject",
            "click   .add-workflow-link": "_onClickViewMarketplaceWorkflows",
            "click   #add-project-dialog .add-demo-project-trigger": "_onCreateProjectAddDemoProjectClick",
            "click   #add-project-dialog .import-project-trigger": "_onClickImportProject",
            "click   #add-project-dialog .create-with-shared-config": "_onClickCreateShared",
            "keydown #add-project-dialog .pt-templates-list": "_onKeydownInTemplatesList"
        },

        draw: function() {
            var dialog = new Dialog({
                width: 840,
                height: 400,
                id: "add-project-dialog",
                closeOnOutsideClick: false,
                keypressListener: _.bind(this._onKeyPressed, this)
            });

            var $dialog = dialog.popup.element;

            dialog.addPage("project-templates-page");

            dialog.addHeader(AJS.I18n.getText("add.project.select.template.title"), "add-project-dialog-header");

            dialog.addPanel("ProjectTemplatesListPanel", JIRA.Templates.ProjectTemplates.loadingTemplatesList(), "pt-content");

            this._dialog = dialog;
            this._$dialogElement = $dialog;

            dialog.show();

            return dialog;
        },

        /**
         * Removes this DialogView.
         *
         * @return {*}
         */
        remove: function() {
            this._dialog && this._dialog.remove();
        },

        showErrorMessage: function(message) {
            this._dialog.getPanel(1, 0).html(JIRA.Templates.errorMsg({
                closable: false,
                msg: message
            }));
        },

        get$PTContent: function getPTContent() {
            return this.getDialogController().$dialogElement.find(".pt-content");
        },

        /**
         * Removes this dialog when ESC is pressed. Note that this is called on keydown anywhere within the dialog,
         * including all steps of the wizard, so you want to be careful about what you do in here.
         *
         * @param {jQuery.Event} e the keydown Event
         * @returns {boolean}
         * @private
         */
        _onKeyPressed: function(e) {
            var escapeKey = 27;
            if (this._dialog) {
                if (e.keyCode === escapeKey) {
                    this.getDialogController().hideDialogFromNewUser("dismissed");
                    this._dialog.remove();
                    return false; // preventDefault, don't propagate.
                }
            }

            return true;
        },

        /**
         * Proceeds to the next step of the wizard when the user presses ENTER in the project templates list.
         * Unfortunately in this case we can't rely on browser auto-submit of forms because the focus is not inside a
         * text input/
         *
         * @param {jQuery.Event} e
         * @returns {boolean}
         * @private
         */
        _onKeydownInTemplatesList: function(e) {
            var enterKey = 13;
            if (this._dialog) {
                if (e.keyCode === enterKey) {
                    this._$dialogElement.find(".pt-submit-button:visible").click();
                    return false;
                }
            }

            return true;
        },

        _onClickAddProject: function(event) {
            event.preventDefault();
            this.getDialogController().handleProjectTemplateTriggered();
        },

        _onCreateProjectAddDemoProjectClick: function() {
            Trigger('analyticsEvent', {name: 'jira.project.templates.dialog.create.demo.create.project.clicked'});
        },

        _onClickViewMarketplaceWorkflows: function () {
            Trigger('analyticsEvent', {name: 'jira.project.templates.dialog.create.viewmarketplaceworkflows.clicked'});
        },

        _onClickAddDemoProject: function(event) {
            event.preventDefault();
            var dialog = this.getDialogController().dialog;
            if (dialog && dialog.popup && dialog.popup.element) {
                dialog.remove();
            }
            this.getDialogController().handleDemoProjectTemplateTriggered();
        },

        _onClickImportProject: function(event) {
            this.getDialogController().hideDialogFromNewUser("importproject");
        },

        _onClickCreateShared: function(event) {
            this.getDialogController().handleCreateShared();
        },

        getDialogController: function() {
            return require('jira/project-templates/dialog-controller');
        }
    });
});

define('jira/project-templates/dialog-view', [
    'jira/project-templates/dialog-view-impl',
    'jquery'
], function(
    DialogViewImpl,
    $
){
    return new DialogViewImpl({ el: $(document) });
});
AJS.namespace('JPT.DialogView', null, require('jira/project-templates/dialog-view'));