AJS.test.require(["com.atlassian.jira.project-templates-plugin:test-resources"], function(){
    "use strict";
    module("JPT.DialogController", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(AJS, "trigger");

            this.wrmData = require('wrm/data');
            this.sandbox.stub(this.wrmData, 'claim');
            this.wrmData.claim.withArgs('com.atlassian.jira.project-templates-plugin:project-templates-plugin-resources.ptAnalyticsData').returns({instanceCreatedDate: '2016-01-05'});

            this.metaGet = sinon.stub(AJS.Meta, "get");
            this.jQueryAjax = sinon.spy(jQuery, "ajax");
            this.DialogController = require('jira/project-templates/dialog-controller');

            this.projectDataJSON = '{"projectTemplatesGroupedByType":[{"projectTypeBean":{"projectTypeKey":"software","projectTypeDisplayKey":"Software","icon":"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pg0KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE4LjEuMSwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPg0KPHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJMYXllcl8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDMwMCAzMDAiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDMwMCAzMDA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj4NCjxnIGlkPSJMYXllcl8yIj4NCgk8cGF0aCBzdHlsZT0iZmlsbDojRjc5MjMyOyIgZD0iTTE1MCwwQzY2LjY2NywwLDAsNjYuNjY3LDAsMTUwczY2LjY2NywxNTAsMTUwLDE1MHMxNTAtNjYuNjY3LDE1MC0xNTBTMjMzLjMzMywwLDE1MCwweg0KCQkgTTEzNi42NjcsMTc4LjMzM0wxMjUsMTkwbC00MS42NjctNDBMOTUsMTM4LjMzM2wzMC0zMEwxMzYuNjY3LDEyMGwtMzAsMzBMMTM2LjY2NywxNzguMzMzeiBNMjA1LDE2MS42NjdsLTMwLDMwTDE2My4zMzMsMTgwDQoJCWwzMC0zMGwtMzAtMzBMMTc1LDEwOC4zMzNMMjE2LjY2NywxNTBMMjA1LDE2MS42Njd6Ii8+DQo8L2c+DQo8Zz4NCgk8cG9seWdvbiBzdHlsZT0iZmlsbDojRkZGRkZGOyIgcG9pbnRzPSIxNzUsMTkxLjY2NyAyMDUsMTYxLjY2NyAyMTYuNjY3LDE1MCAxNzUsMTA4LjMzMyAxNjMuMzMzLDEyMCAxOTMuMzMzLDE1MCAxNjMuMzMzLDE4MCAJIi8+DQoJPHBvbHlnb24gc3R5bGU9ImZpbGw6I0ZGRkZGRjsiIHBvaW50cz0iMTI1LDEwOC4zMzMgOTUsMTM4LjMzMyA4My4zMzMsMTUwIDEyNSwxOTAgMTM2LjY2NywxNzguMzMzIDEwNi42NjcsMTUwIDEzNi42NjcsMTIwIAkiLz4NCjwvZz4NCjwvc3ZnPg0K"},"projectTemplates":[{"name":"Scrum software development","description":"Agile development with a board, sprints and stories. Connects with source and build tools.","iconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/7.1.11-SNAPSHOT/_/download/resources/com.pyxis.greenhopper.jira:software-demo-project-scrum/scrum.png","backgroundIconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/7.1.11-SNAPSHOT/_/download/resources/com.pyxis.greenhopper.jira:software-demo-project-scrum/transparent-background.gif","projectTypeKey":"software","weight":160,"createProject":true,"longDescriptionContent":"You are creating a project for a Scrum team. You may want to name this project after the product or development team that will use it.","itemModuleCompleteKey":"software-demo-project-scrum","demoProject":true},{"name":"Kanban software development","description":"Optimise development flow with a board. Connects with source and build tools.","iconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/7.1.11-SNAPSHOT/_/download/resources/com.pyxis.greenhopper.jira:software-demo-project-kanban/kanban.png","backgroundIconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/7.1.11-SNAPSHOT/_/download/resources/com.pyxis.greenhopper.jira:software-demo-project-kanban/transparent-background.gif","projectTypeKey":"software","weight":161,"createProject":true,"longDescriptionContent":"You are creating a project for a Kanban team. You may want to name this project after the team that will use it (e.g. Bug Fix, Devops).","itemModuleCompleteKey":"software-demo-project-kanban","demoProject":true}],"applicationInfo":{"licenseTotalSeats":-1,"licenseUsedSeats":1,"canUserUseApplication":true,"canUserBeAddedToApplication":false,"applicationName":"JIRA Software","ondemand":false}},{"projectTypeBean":{"projectTypeKey":"service_desk","projectTypeDisplayKey":"Service Desk","icon":"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pg0KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE4LjEuMSwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPg0KPHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJMYXllcl8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDMwMCAzMDAiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDMwMCAzMDA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj4NCjxnIGlkPSJMYXllcl8yIj4NCgk8Zz4NCgkJPHJlY3QgeD0iMTAwIiB5PSIxMDAiIHN0eWxlPSJmaWxsOiM2N0FCNDk7IiB3aWR0aD0iMTAwIiBoZWlnaHQ9IjY2LjY2NyIvPg0KCQk8cGF0aCBzdHlsZT0iZmlsbDojNjdBQjQ5OyIgZD0iTTE1MCwwQzY2LjY2NywwLDAsNjYuNjY3LDAsMTUwczY2LjY2NywxNTAsMTUwLDE1MHMxNTAtNjYuNjY3LDE1MC0xNTBTMjMzLjMzMywwLDE1MCwweg0KCQkJIE0yMTYuNjY3LDEwMHY2Ni42Njd2MTYuNjY3aC01MFYyMDBIMjAwdjE2LjY2N0gxMDBWMjAwaDMzLjMzM3YtMTYuNjY3aC01MHYtMTYuNjY3VjEwMFY4My4zMzNoMTMzLjMzM1YxMDB6Ii8+DQoJPC9nPg0KPC9nPg0KPHBhdGggc3R5bGU9ImZpbGw6I0ZGRkZGRjsiIGQ9Ik0yMTYuNjY3LDE4My4zMzN2LTE2LjY2N1YxMDBWODMuMzMzSDgzLjMzM1YxMDB2NjYuNjY3djE2LjY2N2g1MFYyMDBIMTAwdjE2LjY2N2gxMDBWMjAwaC0zMy4zMzMNCgl2LTE2LjY2N0gyMTYuNjY3eiBNMTAwLDE2Ni42NjdWMTAwaDEwMHY2Ni42NjdIMTAweiIvPg0KPC9zdmc+DQo="},"projectTemplates":[{"name":"IT Service Desk","description":"Service management out of the box. Incidents, service requests and more.","iconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/3.1.0-OD-09-001-D20151221T080724/_/download/resources/com.atlassian.servicedesk:sd-demo-project/project-template-itil-service-desk-icon.png","backgroundIconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/3.1.0-OD-09-001-D20151221T080724/_/download/resources/com.atlassian.servicedesk:sd-demo-project/transparent-background.gif","projectTypeKey":"service_desk","weight":125,"createProject":true,"longDescriptionContent":"Your key will be part of the reference number for customer requests (e.g. DESK-210). Choose a key that clearly identifies your team.","itemModuleCompleteKey":"sd-demo-project","demoProject":true}],"applicationInfo":{"licenseTotalSeats":5,"licenseUsedSeats":1,"canUserUseApplication":true,"canUserBeAddedToApplication":false,"applicationName":"JIRA Service Desk","ondemand":false}},{"projectTypeBean":{"projectTypeKey":"business","projectTypeDisplayKey":"Business","icon":"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pg0KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE4LjEuMSwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPg0KPHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJMYXllcl8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDMwMCAzMDAiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDMwMCAzMDA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj4NCjxnIGlkPSJMYXllcl8yIj4NCgk8cGF0aCBzdHlsZT0iZmlsbDojMzU3MkIwOyIgZD0iTTE1MCwwQzY2LjY2NywwLDAsNjYuNjY3LDAsMTUwczY2LjY2NywxNTAsMTUwLDE1MHMxNTAtNjYuNjY3LDE1MC0xNTBTMjMzLjMzMywwLDE1MCwweg0KCQkgTTE2Ni42NjcsMjE2LjY2N0g4My4zMzNWMjAwaDgzLjMzM1YyMTYuNjY3eiBNMjE2LjY2NywxODMuMzMzSDgzLjMzM3YtMTYuNjY3aDEzMy4zMzNWMTgzLjMzM3ogTTIxNi42NjcsMTUwSDgzLjMzM3YtMTYuNjY3DQoJCWgxMzMuMzMzVjE1MHogTTIxNi42NjcsMTE2LjY2N0g4My4zMzNWMTAwaDEzMy4zMzNWMTE2LjY2N3oiLz4NCjwvZz4NCjxyZWN0IHg9IjgzLjMzMyIgeT0iMjAwIiBzdHlsZT0iZmlsbDojRkZGRkZGOyIgd2lkdGg9IjgzLjMzMyIgaGVpZ2h0PSIxNi42NjciLz4NCjxyZWN0IHg9IjgzLjMzMyIgeT0iMTY2LjY2NyIgc3R5bGU9ImZpbGw6I0ZGRkZGRjsiIHdpZHRoPSIxMzMuMzMzIiBoZWlnaHQ9IjE2LjY2NyIvPg0KPHJlY3QgeD0iODMuMzMzIiB5PSIxMzMuMzMzIiBzdHlsZT0iZmlsbDojRkZGRkZGOyIgd2lkdGg9IjEzMy4zMzMiIGhlaWdodD0iMTYuNjY3Ii8+DQo8cmVjdCB4PSI4My4zMzMiIHk9IjEwMCIgc3R5bGU9ImZpbGw6I0ZGRkZGRjsiIHdpZHRoPSIxMzMuMzMzIiBoZWlnaHQ9IjE2LjY2NyIvPg0KPC9zdmc+DQo="},"projectTemplates":[{"name":"Task management","description":"Simple task management demo data to demonstrate the core features of JIRA.","iconUrl":"/jira/s/en_AU-y40i27/71001/b6b48b2829824b869586ac216d119363/6.0.10/_/download/resources/com.atlassian.jira-core-project-templates:core-demo-project/project-template-core-task-management.svg","projectTypeKey":"business","weight":125,"createProject":true,"itemModuleCompleteKey":"core-demo-project","demoProject":true}],"applicationInfo":{"licenseTotalSeats":0,"licenseUsedSeats":0,"canUserUseApplication":true,"canUserBeAddedToApplication":false,"applicationName":"JIRA Core","ondemand":false}}],"maxNameLength":80,"minNameLength":2,"maxKeyLength":10,"shouldShowProjectLead":true,"serverId":"B99U-9SOS-H9EU-PKVL","currentUserDisplayName":"admin","currentUserName":"admin","currentUserAvatarUrl":"http://www.gravatar.com/avatar/a3175a452c7a8fea80c62a198a40f6c9?d=mm&s=16","projectCount":8}';
            this.projectData = JSON.parse(this.projectDataJSON);
        },

        teardown: function () {
            this.metaGet.restore();
            this.jQueryAjax.restore();
            this.sandbox.restore();
        }
    });

    test("Dialog hidden from new user", function() {
        var dismissalReason = "test";
        this.metaGet.withArgs('show-welcome-screen').returns(true);

        JPT.DialogController.hideDialogFromNewUser(dismissalReason);
        var ajaxConfig = this.jQueryAjax.getCall(0).args[0];
        ok(ajaxConfig.url === AJS.contextPath() + "/rest/welcome/1.0/show/welcome/" + dismissalReason, "Correct 'hide' url");
        ok(ajaxConfig.type === "DELETE", "Correct http verb to hide dialog");
    });

    test("Demo project template dialog triggers analytics event", function () {
        var deferred = jQuery.Deferred();
        this.DialogController.getTemplateController = sinon.stub(this.DialogController, "getTemplateController");
        this.DialogController.getTemplateController.returns({
            loadDemoProjectTemplatesData: function () {
                return deferred;
            }
        });
        this.DialogController.openWithFirstProjectTemplateOfTypePreSelected = sinon.spy();

        this.DialogController.handleDemoProjectTemplateTriggered();
        deferred.resolve(this.projectData);

        sinon.assert.calledOnce(AJS.trigger);
        var callArguments = AJS.trigger.firstCall.args[1];
        deepEqual(callArguments, {
            name: 'jira.project.templates.dialog.create.demo.show',
            data: {
                demoSets: 'software-demo-project-scrum,software-demo-project-kanban,sd-demo-project,core-demo-project',
                instanceCreatedDate: '2016-01-05'
            }
        });
    });
});

