/* eslint-disable */
/* global WRM */

/* Ensure DOM is loaded when React code is included */
AJS.toInit(function () {
    WRM.require(['jira/util/formatter'], function (formatter) {
        var PLUGIN_KEY = 'com.atlassian.jira.plugins.jira-post-upgrade-landing-page-plugin';
        var PULP_UPGRADE_STATUS_DATA_KEY = PLUGIN_KEY + ':pulp-data.upgrade-data';
        var PULP_NEWS_DATA_KEY = PLUGIN_KEY + ':pulp-data.news-data';
        var PULP_APPLINKS_DATA_KEY = PLUGIN_KEY + ":pulp-data.applinks-data";
        var PULP_PLUGIN_DATA_KEY = PLUGIN_KEY + ':pulp-data.plugin-data';

        function sendAnalytics(eventId, attributes) {
            AJS.trigger('analyticsEvent', {
                name: 'post.upgrade.landing.page.' + eventId,
                data: attributes
            });
        }

        var i18nValues = {
            "pulp.intro": formatter.I18n.getText('pulp.intro'),
            "pulp.headline.redirected": formatter.I18n.getText('pulp.headline.redirected'),
            "pulp.headline.not.redirected": formatter.I18n.getText('pulp.headline.not.redirected'),
            "pulp.subheader.no.date": formatter.I18n.getText('pulp.subheader.no.date'),
            "pulp.subheader.with.date": formatter.I18n.getText('pulp.subheader.with.date'),
            "pulp.subheader.checks.summary": formatter.I18n.getText('pulp.subheader.checks.summary'),
            "pulp.subheader.checks.releasenote": formatter.I18n.getText('pulp.subheader.checks.releasenote'),
            "pulp.continuelink": formatter.I18n.getText('pulp.continuelink'),
            "pulp.releasenote.label": formatter.I18n.getText('pulp.releasenote.label'),
            "pulp.releasenote.text": formatter.I18n.getText('pulp.releasenote.text'),
            "pulp.releasenote.link": formatter.I18n.getText('pulp.releasenote.link'),
            "pulp.tooltip.text": formatter.I18n.getText('pulp.tooltip.text'),
            "pulp.rows.details.show": formatter.I18n.getText('pulp.rows.details.show'),
            "pulp.rows.details.hide": formatter.I18n.getText('pulp.rows.details.hide'),
            "pulp.upm.text": formatter.I18n.getText('pulp.upm.text'),
            "pulp.upm.url": formatter.I18n.getText('pulp.upm.url'),
            "pulp.rows.news.headline": formatter.I18n.getText('pulp.rows.news.headline'),
            "pulp.rows.news.description": formatter.I18n.getText('pulp.rows.news.description'),
            "pulp.rows.plugins.headline.enabled": formatter.I18n.getText('pulp.rows.plugins.headline.enabled'),
            "pulp.rows.plugins.headline.disabled": formatter.I18n.getText('pulp.rows.plugins.headline.disabled'),
            "pulp.rows.plugins.description.enabled": formatter.I18n.getText('pulp.rows.plugins.description.enabled'),
            "pulp.rows.plugins.description.disabled": formatter.I18n.getText('pulp.rows.plugins.description.disabled'),
            "pulp.rows.plugins.kb.prompt": formatter.I18n.getText('pulp.rows.plugins.kb.prompt'),
            "pulp.rows.plugins.upmlink.enabled": formatter.I18n.getText('pulp.rows.plugins.upmlink.enabled'),
            "pulp.rows.plugins.upmlink.disabled": formatter.I18n.getText('pulp.rows.plugins.upmlink.disabled'),
            "pulp.rows.applinks.headline.success": formatter.I18n.getText('pulp.rows.applinks.headline.success'),
            "pulp.rows.applinks.headline.fail": formatter.I18n.getText('pulp.rows.applinks.headline.fail'),
            "pulp.rows.applinks.description.success": formatter.I18n.getText('pulp.rows.applinks.description.success'),
            "pulp.rows.applinks.description.fail": formatter.I18n.getText('pulp.rows.applinks.description.fail'),
            "pulp.rows.applinks.label": formatter.I18n.getText('pulp.rows.applinks.label'),
            "pulp.rows.applinks.detail.fail": formatter.I18n.getText('pulp.rows.applinks.detail.fail'),
            "pulp.rows.applinks.detail.success": formatter.I18n.getText('pulp.rows.applinks.detail.success'),
            "pulp.rows.applinks.stp.text": formatter.I18n.getText('pulp.rows.applinks.stp.text'),
            "pulp.rows.applinks.stp.label": formatter.I18n.getText('pulp.rows.applinks.stp.label')
        };

        window.initialData = WRM.data.claim(PULP_UPGRADE_STATUS_DATA_KEY);
        window.initialData.rows = {
            news: WRM.data.claim(PULP_NEWS_DATA_KEY),
            plugins: WRM.data.claim(PULP_PLUGIN_DATA_KEY),
            applinks: WRM.data.claim(PULP_APPLINKS_DATA_KEY)
        };
        window.initialData.contextPath = AJS.contextPath();
        window.analyticsEventSender = sendAnalytics;
        window.i18n = i18nValues;
        WRM.require(["com.atlassian.jira.plugins.jira-post-upgrade-landing-page-plugin:pulp-js"]);
    });
});