define('jira/issues/views/details/metrics', [
    'jira/util/logger',
    'internal/browser-metrics'
], function (
    logger,
    metrics
) {
    "use strict";

    return {
        viewIssue: function () {
            metrics.start({
                isInitial: true,
                key: "jira.issue.view",
                ready: [
                    "#key-val",
                    ".issue-body-content"
                ]
            });
        },

        startFromPageLoad: function () {
            metrics.start({
                isInitial: true,
                key: "jira.issue.nav-detail"
            });
        },

        start: function () {
            logger.debug('JSEV-722: AJAX-based transition metric not fired. Need to fix JSEV-1087 first.');
            // metrics.start({
            //     key: "jira.issue.nav-detail"
            // });
        },

        end: function () {
            metrics.end({
                key: "jira.issue.nav-detail"
            });
        }
    };
});
