define('jira/issues/views/details/application-adapter', [
], function (
) {
    "use strict";

    var existingHandlers = {
        "reqres": {},
        "commands": {}
    };

    function replaceHandlers(type, handlers) {
        for (var handlerName in handlers) {
            var implementation = handlers[handlerName];

            if (JIRA.Issues.Application.reqres.hasHandler(handlerName)) {
                existingHandlers[type][handlerName] = JIRA.Issues.Application.reqres.getHandler(handlerName);
            } else {
                existingHandlers[type][handlerName] = null;
            }

            JIRA.Issues.Application.reqres.setHandler(handlerName, implementation);
        }
    }

    function restoreReqRes(type) {
        for (var handlerName in existingHandlers[type]) {
            var implementation = existingHandlers[type][handlerName];

            if (implementation) {
                JIRA.Issues.Application.reqres.setHandler(handlerName, implementation);
            } else {
                JIRA.Issues.Application.reqres.removeHandler(handlerName);
            }

            delete existingHandlers[type][handlerName];
        }
    }

    return {
        init: function (detailsLayout) {
            replaceHandlers("reqres", {
                "issueEditor:canDismissComment": function() {
                    return detailsLayout.canDismissComment();
                },
                "issueEditor:getIssueId": function() {
                    return detailsLayout.getActiveIssueId();
                },
                "issueEditor:getIssueKey": function() {
                    return detailsLayout.getActiveIssueKey();
                },
                "issueEditor:refreshIssue": function() {
                    return detailsLayout.refreshIssue();
                },
                "issueEditor:isCurrentlyLoading": function() {
                    return detailsLayout.isLoading();
                },
                "issueEditor:hasSavesInProgress": function() {
                    return detailsLayout.hasSavesInProgress();
                },
                "issueEditor:fields": function() {
                    return detailsLayout.getEditorFields();
                }
            });

            replaceHandlers("commands", {
                "issueEditor:abortPending": function() {
                    return detailsLayout.abortPending();
                },
                "issueEditor:beforeHide": function() {
                    return detailsLayout.beforeHide();
                },
                "issueEditor:beforeShow": function() {
                    return detailsLayout.beforeShow();
                },
                "issueEditor:removeIssueMetadata": function() {
                    return detailsLayout.removeIssueMetadata();
                },
                "issueEditor:updateIssueWithQuery": function() {
                    return detailsLayout.updateIssueComponent();
                },
                "issueEditor:editField": function(field) {
                    return detailsLayout.editField(field);
                }
            });
        },

        destroy: function() {
            restoreReqRes("reqres");
            restoreReqRes("commands");
        }
    };
});
