define("jira/issues/views/details/analytics", [
], function(
) {
    "use strict";

    return {
        triggerIssueTableRefresh: function() {
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.issueTableRefresh", {
                source: "jira.issuenav.global"
            });
        },

        triggerOpenIssueFromTable: function(data) {
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.openIssueFromTable", {
                issueId: data.id,
                absolutePosition: data.absolutePosition + 1,
                relativePosition: data.relativePosition + 1,
                source: "jira.issuenav.global"
            });
        },

        triggerViewIssue: function(data){
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.viewIssue", {
                issueId: data.issueId,
                loadReason: data.loadReason,
                duration: data.duration,
                loadedFromDom: false,
                source: "jira.issuenav.global",
                projectId: data.projectId,
                projectType: data.projectType || 'unknown',
                issueMatchesProjectContext: data.issueKey == null ? false : data.issueKey.indexOf(data.projectKey + "-") === 0
            });
        },

        triggerInlineEdit: function(data) {
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.inlineEdit", {
                issueId: data.issueId,
                savedFieldIds: data.savedFieldIds,
                savedFieldTypes: data.savedFieldTypes,
                duration: data.duration,
                source: "jira.issuenav.global"
            });
        },

        triggerInlineEditStart: function(data) {
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.inlineEdit.start", {
                issueId: data.issueId,
                fieldId: data.fieldId,
                fieldType: data.fieldType,
                source: "jira.issuenav.global"
            });
        },

        triggerInlineEditCancel: function(data) {
            JIRA.Issues.Application.execute("analytics:trigger", "kickass.inlineEdit.cancel", {
                issueId: data.issueId,
                fieldId: data.fieldId,
                fieldType: data.fieldType,
                source: "jira.issuenav.global"
            });
        }
    };
});
