define("jira/issues/utils/resize", [], function () {
    "use strict";

    var _ = require("underscore");
    var jQuery = require("jquery");

    var horizontalEventName = "horizontalResize";
    var verticalEventName = "verticalResize";

    return {
        offHorizontalResize: function (block) {
            jQuery(document).off(horizontalEventName, block);
        },

        onHorizontalResize: function (block) {
            jQuery(document).on(horizontalEventName, block);
        },

        triggerHorizontalResize: _.throttle(function () {
            jQuery(document).trigger(horizontalEventName);
        }, 100),

        offVerticalResize: function (block) {
            jQuery(document).off(verticalEventName, block);
        },

        onVerticalResize: function (block) {
            jQuery(document).on(verticalEventName, block);
        },

        triggerVerticalResize: _.throttle(function () {
            jQuery(document).trigger(verticalEventName);
        }, 100),

        /**
         * A vertical resize event is triggered when the page changes in such a way that elements may need to resize themselves
         * vertically (e.g. an element is added/removed, or an element's height changes).
         */
        init: function () {
            jQuery(window).resize(this.triggerVerticalResize);
        }
    };
});
(function () {
    "use strict";
    var resize = require("jira/issues/utils/resize");
    resize.init();
}());
AJS.namespace("JIRA.Issues.offHorizontalResize", null, require("jira/issues/utils/resize").offHorizontalResize);
AJS.namespace("JIRA.Issues.onHorizontalResize", null, require("jira/issues/utils/resize").onHorizontalResize);
AJS.namespace("JIRA.Issues.triggerHorizontalResize", null, require("jira/issues/utils/resize").triggerHorizontalResize);
AJS.namespace("JIRA.Issues.offVerticalResize", null, require("jira/issues/utils/resize").offVerticalResize);
AJS.namespace("JIRA.Issues.onVerticalResize", null, require("jira/issues/utils/resize").onVerticalResize);
AJS.namespace("JIRA.Issues.triggerVerticalResize", null, require("jira/issues/utils/resize").triggerVerticalResize);
