define("jira/issues/feature", ["require"], function(require){
    "use strict";

    var DarkFeatures = require("jira/ajs/dark-features");

    return Class.extend({
        /**
         * Creates a new Feature object for the given feature key.
         *
         * @param featureKey {String} the name of the feature
         */
        init: function(featureKey) {
            this.featureKey = featureKey;
        },

        /**
         * Returns true if this Feature is enabled.
         *
         * @return {Boolean}
         */
        enabled: function() {
            return DarkFeatures.isEnabled(this.featureKey);
        }
    });
});

/**
 * Holds the dark feature switches that affect how the KA app works.
 */
define("jira/issues/dark-features", ["require"], function(require){
    "use strict";

    var Feature = require("jira/issues/feature");

    return {
        /**
         * If enabled, kills issue prefetching.
         */
        NO_PREFETCH: new Feature("ka.NO_PREFETCH"),

        /**
         * If enabled, project's avatar will display a popup on click
         */
        PROJECT_SHORTCUTS: new Feature("rotp.project.shortcuts")
    };

});

AJS.namespace("JIRA.Issues.Feature", null, require("jira/issues/feature"));
AJS.namespace("JIRA.Issues.DarkFeatures", null, require("jira/issues/dark-features"));
