define("jira/issues/layer-positioning/window", ["require"], function (require) {
    "use strict";

    var StandardPositioning = require('jira/ajs/layer/inline-layer/standard-positioning');
    var jQuery = require('jquery');

    /**
     * An <tt>AJS.InlineLayer</tt> positioning controller that ensures the layer doesn't overflow the bottom of the window.
     */
    return StandardPositioning.extend({
        /**
         * @param {object} offset The offset from which to calculate the overflow.
         * @return {Number} The amount by which the layer overflows the window.
         * @private
         */
        _calculateOverflow: function(offset) {
            var isFixed = this.layer().css("position") === "fixed";
            var layerBottom = offset.top + this.layer().outerHeight(true);
            var windowHeight = window.innerHeight;
            var windowScroll = jQuery(window).scrollTop();

            if (isFixed) {
                return Math.max(0, layerBottom - windowHeight);
            } else {
                return Math.max(0, layerBottom - windowScroll - windowHeight);
            }
        },

        left: function() {
            var offset = this._super();
            var overflow = this._calculateOverflow(offset);

            if (overflow > 0) {
                offset.left += this.offsetTarget().outerWidth();
                offset.top -= overflow;
            }

            return offset;
        },

        right: function() {
            var offset = this._super();
            var overflow = this._calculateOverflow(offset);

            if (overflow > 0) {
                offset.left -= this.offsetTarget().outerWidth();
                offset.top -= overflow;
            }

            return offset;
        }
    });
});
AJS.namespace("JIRA.Issues.WindowPositioning", null, require("jira/issues/layer-positioning/window"));
