AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils", "com.atlassian.jira.jira-issue-nav-plugin:viewissue"], function() {
    "use strict";

    var jQuery = require("jquery");
    var Reasons = require("jira/util/events/reasons");
    var Types = require("jira/util/events/types");
    var Application = require("jira/issues/application");
    var FullScreenIssue = require("jira/issues/search/issue/full-screen-issue");
    var Events = require('jira/util/events');

    module("jira/issues/search/issue/full-screen-issue", {
        setup: function() {
            this.fullScreenIssue = new FullScreenIssue({
                issueContainer: jQuery('<div></div>'),
                searchContainer: jQuery('<div></div>')
            });
            Application.start();
        },

        teardown: function() {
            Application.stop();
        }
    });

    test("_makeIssueVisible() should trigger a JIRA.Events.NEW_CONTENT_ADDED", function() {
        var triggerSpy = sinon.spy(Events, "trigger");

        this.fullScreenIssue._makeIssueVisible();

        equal(triggerSpy.callCount, 1, "One event is triggered");
        equal(triggerSpy.firstCall.args[0], Types.NEW_CONTENT_ADDED, "Event is JIRA.Events.NEW_CONTENT_ADDED");
        equal(typeof triggerSpy.firstCall.args[1][1], "string", "Ensure event has a reason argument");
        equal(triggerSpy.firstCall.args[1][1], Reasons.pageLoad, "Event reason is JIRA.CONTENT_ADDED_REASON.pageLoad");

        triggerSpy.restore();
    });
});
