AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:issuenav"],function(){module("JIRA.Issues.SearchResults",{setup:function(){this.canDismissCommentStub=sinon.stub(JIRA.Issues.Application,"request");this.canDismissCommentStub.returns(true);this.createSearchResults=function(a){return JIRA.Issues.TestUtils.mockSearchResults(a)};this.createDefaultSearchResults=function(b){b=b||{};var c=b.totalIssues||b.issues||12;var a=("issues" in b)?_.range(1,Math.max(1,b.issues+1)):_.range(1,10);return this.createSearchResults({startIndex:0,issueIds:a,total:c,pageSize:b.pageSize||3})}},teardown:function(){this.canDismissCommentStub.restore()}});test("getStartIndexForPage returns correct page",function(){var a=this.createSearchResults({pageSize:10});equal(10,a.getStartIndexForPage(1));equal(20,a.getStartIndexForPage(2));a=this.createSearchResults({pageSize:20});equal(20,a.getStartIndexForPage(1));equal(40,a.getStartIndexForPage(2))});test("hasIssue returns correct value",function(){var a=this.createSearchResults({pageSize:2,issueIds:[1,2,3,4,5]});ok("Expected issue not to exist on page",!a.hasIssue(10));ok("Expected issue to exist on page",a.hasIssue(1));ok("Expected issue to exist on page",a.hasIssue(5))});test("getPager returns valid pager",function(){var b=this.createDefaultSearchResults();b.selectIssueById(4);var a=b.getPager();equal(a.position,4,"Issue in the pager should be at the correct position");equal(a.resultCount,12,"Result count on the pager should reflect the correct issues count");equal(a.nextIssue.id,5,"The next issue should point to the correct issue");equal(a.previousIssue.key,"HSP-3","The prev issue should point to the correct issue");b.selectIssueById(1);a=b.getPager(1);equal(a.position,1,"Issue in the pager should be at the correct position");equal(a.resultCount,12,"Result count on the pager should reflect the correct issues count");equal(a.nextIssue.key,"HSP-2","The next issue should point to the correct issue");equal(a.previousIssue,undefined,"The prev issue should be undefined");b.selectIssueById(9);a=b.getPager();equal(a.position,9,"Issue in the pager should be at the correct position");equal(a.resultCount,12,"Result count on the pager should reflect the correct issues count");equal(a.nextIssue,undefined,"The next issue should be undefined");equal(a.previousIssue.id,8,"The prev issue should point to the correct issue")});test("getNumberOfPages gives correct number of pages",function(){var a=this.createDefaultSearchResults();equal(a.getNumberOfPages(),2);a=this.createDefaultSearchResults({issues:50,pageSize:2});equal(a.getNumberOfPages(),24);a=this.createDefaultSearchResults({issues:0,pageSize:1});equal(a.getNumberOfPages(),-1);a=this.createDefaultSearchResults({issues:50,pageSize:50});equal(a.getNumberOfPages(),0)});test("Removing highlighted issue, highlights next issue if there is one",function(){var a=this.createDefaultSearchResults({issues:3});a.highlightIssueById(1);a.removeIssue(1);equal(a.getHighlightedIssue().getId(),2);a.removeIssue(2);equal(a.getHighlightedIssue().getId(),3);a.removeIssue(3);equal(a.getIssueIds().length,0)});test("Issue is deleted if issueUpdate is delete",function(){var b=sinon.spy();var c=sinon.spy();var a=this.createDefaultSearchResults({issues:3});a.bindIssueDeleted(b);a.bindIssueUpdated(c);a.updateIssue({id:1,action:JIRA.Issues.Actions.DELETE});ok(!a.hasIssue(1));equal(c.callCount,0);equal(b.callCount,1)});test("Issue update issueUpdate goes to server",function(){var b=sinon.spy();var c=sinon.spy();var a=this.createDefaultSearchResults({issues:3});a.bindIssueDeleted(b);a.onIssueUpdated(c);a.updateIssue({id:1});ok(a.hasIssue(1));equal(a._issueSearchManager.getRowsForIds.callCount,1);equal(c.callCount,1);equal(b.callCount,0)});test("UpdateIssueById calls updateIssue",function(){var b=sinon.spy();var a=this.createDefaultSearchResults({issues:3});a.updateIssue=sinon.spy();a.updateIssueById({id:123,action:JIRA.Issues.Actions.UPDATE},{filter:b});ok(a.updateIssue.calledWith({id:123,action:JIRA.Issues.Actions.UPDATE},{filter:b}))});test("Selecting Issue By Key",function(){var a=sinon.spy();var b=sinon.spy();var c=this.createDefaultSearchResults();c.onSelectedIssueChange(function(d){if(d.hasIssue()){a(d)}});c.bind("issueDoesNotExist",b);c.selectIssueByKey("HSP-3");equal(c.getSelectedIssue().getId(),3);c.selectIssueByKey("HSP-3");equal(c.getSelectedIssue().getId(),3);equal(a.callCount,1,"Selecting same issue doesn't fire another event");c.selectIssueByKey("MON-10");equal(c.getSelectedIssue().getId(),-1);equal(c.getSelectedIssue().getKey(),"MON-10");equal(c.getHighlightedIssue().getId(),null);equal(c.getHighlightedIssue().getKey(),null);ok(b.calledOnce,"issueDoesNotExist Event triggered");c.selectIssueByKey("HSP-4");equal(c.getSelectedIssue().getKey(),"HSP-4");equal(c.getSelectedIssue().getId(),4);c.selectIssueByKey(null);equal(c.getSelectedIssue().getKey(),null,"Selecting null issue key should remove selection");equal(c.getSelectedIssue().getId(),null,"Selecting null issue key should remove selection")});test("Highlighting issue sets correct start index",function(){var a=this.createDefaultSearchResults({issues:50});a.highlightIssueById(49);equal(a.getStartIndex(),48);a.highlightIssueById(10);equal(a.getStartIndex(),9);a.highlightIssueById(1);equal(a.getStartIndex(),0);a.highlightIssueById(25);equal(a.getStartIndex(),24)});test("Highlighting first in page",function(){var a=this.createDefaultSearchResults({issues:10,pageSize:5});a.highlightIssueById(10);a.highlightFirstInPage();equal(a.getHighlightedIssue().getId(),6);ok(!a.isFirstIssueHighlighted());a.highlightIssueById(3);a.highlightFirstInPage();equal(a.getHighlightedIssue().getId(),1);ok(a.isFirstIssueHighlighted())});test("Highlighting next and previous across page boundaries",function(){var a=this.createDefaultSearchResults({issues:50,pageSize:5});a.resetFromSearch(a.toJSON());equal(a.getHighlightedIssue().getId(),1);a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),2);a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),3);a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),4);a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),5);equal(a.getStartIndex(),0);a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),6);equal(a.getStartIndex(),5);a.highlightPrevIssue();equal(a.getHighlightedIssue().getId(),5);equal(a.getStartIndex(),0)});test("highlighted roof/floor",function(){var a=this.createDefaultSearchResults({issues:4,pageSize:2});a.highlightIssueById(1);a.highlightPrevIssue();a.highlightPrevIssue();equal(a.getHighlightedIssue().getId(),1);a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();a.highlightNextIssue();equal(a.getHighlightedIssue().getId(),4)});test("Detects if first issue is selected",function(){var a=this.createDefaultSearchResults({issues:4,pageSize:2});a.selectIssueById(1);ok(a.isFirstIssueSelected());a.selectNextIssue();ok(!a.isFirstIssueSelected())});test("selected roof/floor",function(){var a=this.createDefaultSearchResults({issues:4,pageSize:2});a.selectIssueById(1);a.selectPrevIssue();a.selectPrevIssue();equal(a.getSelectedIssue().getId(),1);a.selectNextIssue();a.selectNextIssue();a.selectNextIssue();a.selectNextIssue();a.selectNextIssue();a.selectNextIssue();a.selectNextIssue();equal(a.getHighlightedIssue().getId(),4)});test("Going to page highlights first issue on page",function(){var a=this.createDefaultSearchResults();a.goToPage(4);equal(a.getHighlightedIssue().getId(),5);a.goToPage(0);equal(a.getHighlightedIssue().getId(),1)});test("Reset from search, clears and updates correct properties",function(){var a=this.createDefaultSearchResults();a.selectIssueById(4);a.resetFromSearch({issueIds:[1,2,3],sortBy:"summary:DESC"});equal(a.getSelectedIssue().getId(),null,"Selected issue should be set to null on new search");equal(a.getSelectedIssue().getKey(),null,"Selected issue should be set to null on new search");equal(a.getHighlightedIssue().getId(),1,"Highlighted issue should be set to first issue on new search");equal(a.getHighlightedIssue().getKey(),"HSP-1","Highlighted issue should be set to first issue on new search")});test("Deleting an issue removes it from the cache",function(){var a=this.createDefaultSearchResults();var b={remove:sinon.spy()};new JIRA.Issues.Cache.IssueCacheManager({searchResults:a,viewIssueData:b});a.removeIssue(5);ok(b.remove.called,"Issue was removed from the cache")});test("selectNextIssueTriggersTheRightEvents",function(){var b;var a=this.createDefaultSearchResults({pageSize:5});a.bind("nextIssueSelected",function(c){b=c});a.selectFirstInPage();a.selectNextIssue();deepEqual(b.nextIssue,{id:2,key:"HSP-2"},"next should be HSP-2");deepEqual(b.nextNextIssue,{id:3,key:"HSP-3"},"next-next should be HSP-3")});test("selectPrevIssueTriggersTheRightEvents",function(){var b;var a=this.createDefaultSearchResults({pageSize:5});a.bind("prevIssueSelected",function(c){b=c});a.selectIssueByKey("HSP-5");a.selectPrevIssue();deepEqual(b.prevIssue,{id:4,key:"HSP-4"},"next should be HSP-4");deepEqual(b.prevPrevIssue,{id:3,key:"HSP-3"},"next-next should be HSP-3")});test("getResultForId should pass filter's id only when it is not system filter",function(){var b=this.createSearchResults();var a={getIsSystem:sinon.stub(),getId:function(){return 123}};a.getIsSystem.returns(true);b.getResultForId(1001,a);a.getIsSystem.returns(false);b.getResultForId(1001,a);ok(b._issueSearchManager.getRowsForIds.getCall(0).calledWithExactly([1001],{columnConfig:"user"}),"filterId should *not* exist in parameters for system filter");ok(b._issueSearchManager.getRowsForIds.getCall(1).calledWithExactly([1001],{columnConfig:"user",filterId:123}),"filterId should exist in parameters for user defined filter")});test("Dirty comment warning is respected when unselecting or selecting different issue",function(){var a=this.createDefaultSearchResults();var b=sinon.spy();a.onSelectedIssueChange(b,{});this.canDismissCommentStub.returns(false);a.selectIssueById(1);equal(b.callCount,0,"Selected issue isn't changed when user doesn't want to dismiss the comment");a.selectIssueById();equal(b.callCount,0,"Selected issue isn't changed when user doesn't want to dismiss the comment");this.canDismissCommentStub.returns(true);a.selectIssueById(1);equal(b.callCount,1,"Selected issue is changed when user doesn't want to dismiss the comment");a.selectIssueById();equal(b.callCount,2,"Selected issue is changed when user doesn't want to dismiss the comment")})});