AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:issuenav","com.atlassian.jira.jira-issue-nav-plugin:metrics"],function(){module("JIRA.Issues.SearchPageModule",{setup:function(){this.sandbox=sinon.sandbox.create({useFakeServer:true});this.server=this.sandbox.server;JIRA.Issues.Application.start();AJS.params.ignoreFrame=true;this.server=sinon.fakeServer.create();this.searchPageModule=JIRA.Issues.TestUtils.mockSearchPageModule();this.realConfirmation=this.searchPageModule.confirmNavigation;this.shortcutsEnabled=AJS.keyboardShortcutsDisabled;AJS.keyboardShortcutsDisabled=false;this.sandbox.spy(JIRA.Issues.Application,"execute")},teardown:function(){this.sandbox.restore();JIRA.Issues.Application.execute("navigation:updateState",{},{reset:true});JIRA.Issues.Application.stop();JIRA.Issues.Application.off();jQuery(".aui-loading").remove();AJS.keyboardShortcutsDisabled=this.shortcutsEnabled},createStateStub:function(a){return _.extend(a,{isStandaloneIssue:sinon.stub().returns(false)})}});test("confirmNavigation",function(){var c=sinon.stub().returns(true);var b=sinon.stub(JIRA.Issue,"getDirtyCommentWarning");var a=sinon.stub(JIRA.DirtyForm,"getDirtyWarning");this.searchPageModule.confirmNavigation=this.realConfirmation;this.searchPageModule.confirmNavigation({confirm:c});ok(!c.called,"No confirmation requested.");b.returns("Dirty");this.searchPageModule.confirmNavigation({confirm:c});ok(c.called,"Confirmation requested.");b.returns(undefined);a.returns("Filthy");this.searchPageModule.confirmNavigation({confirm:c});equal(2,c.callCount,"Confirmation requested");b("Disgusting");this.searchPageModule.confirmNavigation({confirm:c,ignoreDirtiness:true});equal(2,c.callCount,"No confirmation requested")});test("JRADEV-9594: We can refresh the current search in JQL mode",function(){this.searchPageModule.queryModuleSearchRequested("project = HSP");this.server.respond();this.searchPageModule.queryModuleSearchRequested("project = HSP");equal(this.searchPageModule.issueSearchManager.search.callCount,2,"Two searches were performed")});test("Search triggered from QueryModule resets startIndex",function(){this.searchPageModule.issueSearchManager.search.returns(new jQuery.Deferred().resolve({}).promise());this.searchPageModule.issueTableSortRequested("");ok(this.searchPageModule.searchResults.resetFromSearch.called,"resetFromSearch is called");var a=this.searchPageModule.searchResults.resetFromSearch.getCall(0).args[0];equal(a.startIndex,undefined,"resetFromSearch is called with startIndex == undefined");equal(a.jql,"","resetFromSearch is called with jql = ''")});test("Updating SearchPageModule from router should check if state has changed before resetting",function(){var d=sinon.stub(this.searchPageModule,"getState");var a=sinon.stub(this.searchPageModule,"applyState");var b={routerEvent:true,reset:false,resetQuery:false};d.returns({jql:"GOTTA CATCHEM ALL",filter:null,startIndex:9001,selectedIssueKey:null});var c=_.extend({},this.searchPageModule.getState());c.selectedIssueKey="POKE-2";this.searchPageModule.onStateChanged(this.createStateStub(c),b);ok(a.calledWithExactly(c,false,b),"Apply state is called with isReset false");d.returns(_.extend({},c));c.selectedIssueKey=null;this.searchPageModule.onStateChanged(this.createStateStub(c),b);ok(a.calledWithExactly(c,false,b),"Apply state is called with isReset false");d.returns(_.extend({},c));c.jql="WUT";this.searchPageModule.onStateChanged(this.createStateStub(c),b);ok(a.calledWithExactly(c,true,b),"Apply state is called with isReset true");d.restore();a.restore()});test("returnToSearch should trigger browser-metrics start",function(){var a=require("internal/browser-metrics");this.sandbox.stub(a,"start");this.searchPageModule.fullScreenIssue.isVisible.returns(true);this.searchPageModule.returnToSearch();ok(a.start.calledOnce,"browser-metrics API was called once");equal(a.start.lastCall.args[0].key,"jira.issue.nav-list","browser-metrics API call should be for jira.issue.nav-list");this.searchPageModule.fullScreenIssue.isVisible.returns(false)});test("state change should trigger browser-metrics start for standalone issue",function(){var a=require("internal/browser-metrics");this.sandbox.stub(a,"start");var b=this.createStateStub({selectedIssueKey:"TST-1"});b.isStandaloneIssue.returns(true);this.searchPageModule.onStateChanged(b);ok(a.start.calledOnce,"browser-metrics API was called once");equal(a.start.lastCall.args[0].key,"jira.issue.view","browser-metrics API call should be for jira.issue.view")});test("state change should trigger browser-metrics start, indicating it's an initial page load only on first call",function(){var a=require("internal/browser-metrics");this.sandbox.stub(a,"start");var b=this.createStateStub({selectedIssueKey:"TST-1"});b.isStandaloneIssue.returns(true);this.searchPageModule.onStateChanged(b);this.searchPageModule.onStateChanged(b);ok(a.start.calledTwice,"browser-metrics API was called twice");equal(a.start.firstCall.args[0].isInitial,true,"browser-metrics API call payload should indicate it's on initial page load");equal(a.start.lastCall.args[0].isInitial,false,"browser-metrics API call payload should indicate it's not on initial page load")});test("state change with forceFullPageLoad option does not load the full screen issue component",function(){var a=this.createStateStub({selectedIssueKey:"TST-1"});a.isStandaloneIssue.returns(true);this.searchPageModule.onStateChanged(a,{forceFullPageLoad:true});sinon.assert.notCalled(this.searchPageModule.fullScreenIssue.show)});test("changeLayout",function(){var b=JIRA.Issues.Application.execute.withArgs("analytics:trigger","kickass.issue-navigator.change-layout");var d=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var e=sinon.stub().returns(d);var c=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var a=sinon.stub().returns(c);d.__proto__=e.prototype={};c.__proto__=a.prototype={};this.searchPageModule.registerLayout("a",{label:"A",View:e});this.searchPageModule.registerLayout("b",{label:"B",View:a});this.searchPageModule.changeLayout("a");equal(e.callCount,1,"New layout created");equal(d.render.callCount,1,"render() called on the layout");ok(d===this.searchPageModule.getCurrentLayout(),"Current layout set on SearchPageModule");this.searchPageModule.changeLayout("a");equal(d.close.callCount,0,"Layout not deactivated");equal(e.callCount,1,"No layout created");equal(d.render.callCount,1,"render() not called on the layout");ok(d===this.searchPageModule.getCurrentLayout(),"Layout still set on SearchPageModule");this.searchPageModule.changeLayout("b",{render:false});equal(d.close.callCount,1,"Old layout deactivated");equal(a.callCount,1,"New layout created");equal(c.render.callCount,0,"render() not called on the layout");ok(c===this.searchPageModule.getCurrentLayout(),"Current layout set on SearchPageModule");equal(b.callCount,2,"Analytics called with layout change event")});test("Issue unselected when switching layouts",function(){var c=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var d=sinon.stub().returns(c);var b=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var a=sinon.stub().returns(b);c.__proto__=d.prototype={};b.__proto__=a.prototype={};this.searchPageModule.registerLayout("a",{label:"A",View:d});this.searchPageModule.registerLayout("b",{label:"B",View:a});this.searchPageModule.changeLayout("a");ok(!this.searchPageModule.search.getResults().unselectIssue.called,"If we do not have a previous a layout yet we should no be unselecting");this.searchPageModule.changeLayout("a");ok(!this.searchPageModule.search.getResults().unselectIssue.called,"If we already have that layout activated we should not be unselecting");this.searchPageModule.changeLayout("b",{render:false});ok(this.searchPageModule.search.getResults().unselectIssue.called,"Issue unselected.")});test("get/registerLayout",function(){var a="3d-view";var b={};equal(this.searchPageModule.getLayout(a),null,"getLayout() returns null for unknown layouts");this.searchPageModule.registerLayout(a,b);equal(this.searchPageModule.getLayout(a),b,"getLayout() returns known layouts")});test("getEffectiveJql is doing the right thing",function(){var a=new JIRA.Components.Filters.Models.Filter({id:1,jql:"issuetype = Bug"});this.searchPageModule.setFilter(a);this.searchPageModule.setJql("");equal(this.searchPageModule.getEffectiveJql(),"");this.searchPageModule.setJql(null);equal(this.searchPageModule.getEffectiveJql(),"issuetype = Bug")});test("can't navigate to previous/next when overlay is visible",function(){var a=this;var b=function(e){var c=sinon.spy();var f=sinon.spy();a.searchPageModule.changeLayout(e);a.searchPageModule.getCurrentLayout().nextIssue=c;a.searchPageModule.getCurrentLayout().prevIssue=f;var d=jQuery("<div class='aui-blanket' aria-hidden='false'></div>");jQuery(document.body).append(d);a.searchPageModule.nextIssue();a.searchPageModule.prevIssue();equal(c.callCount,0,"nextIssue not called when overlay is visible");equal(f.callCount,0,"prevIssue not called when overlay is visible");d.remove();a.searchPageModule.nextIssue();a.searchPageModule.prevIssue();equal(c.callCount,1,"nextIssue called when overlay is not visible");equal(f.callCount,1,"prevIssue called when overlay is not visible")};b("list-view");b("split-view")});test("canDismissComment called for both next and prev issue",function(){this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:canDismissComment").returns(false);this.searchPageModule.nextIssue();this.searchPageModule.prevIssue();equal(JIRA.Issues.Application.request.withArgs("issueEditor:canDismissComment").callCount,2,"Expected can Dismiss Comment to be called for both next and prev issue methods")});test("Applying a new state should abort any issue load if there is one",function(){var a=JIRA.Issues.Application.execute.withArgs("issueEditor:abortPending");this.searchPageModule.applyState({jql:""},true);ok(a.calledOnce,"Application.execute was called with 'issueEditor:abortPending'")});test("Unselecting an issue in detail view does not trigger metrics",function(){var a=require("internal/browser-metrics");this.sandbox.stub(a,"start");this.sandbox.stub(JIRA.Issues.LayoutPreferenceManager,"getPreferredLayoutKey").returns("split-view");this.searchPageModule.applyState({jql:"",selectedIssueKey:null},true);ok(a.start.notCalled,"browser-metrics API was not called when issue has been unselected")});test("Down/up arrow key navigates to next/previous issue when allowed",function(){var a=sinon.stub().returns(true);var b=sinon.stub().returns(true);this.searchPageModule.nextIssue=a;this.searchPageModule.prevIssue=b;AJS.InlineLayer.current={};ok(!this.searchPageModule.handleDown(),"Can't navigate down when inline layer is present");ok(!this.searchPageModule.handleUp(),"Can't navigate up when inline layer is present");AJS.InlineLayer.current=null;AJS.Dropdown.current={};ok(!this.searchPageModule.handleDown(),"Can't navigate down when dropdown is present");ok(!this.searchPageModule.handleUp(),"Can't navigate up when dropdown is present");AJS.Dropdown.current=null;JIRA.Dialog.current={};ok(!this.searchPageModule.handleDown(),"Can't navigate down when dialog is present");ok(!this.searchPageModule.handleUp(),"Can't navigate up when dialog is present");JIRA.Dialog.current=null;jQuery("<div id='menu-item' class='aui-dropdown2'></div>").appendTo("body").show();ok(!this.searchPageModule.handleDown(),"Can't navigate down when menu item is open");ok(!this.searchPageModule.handleUp(),"Can't navigate up when menu item is open");jQuery("#menu-item").remove();this.searchPageModule.changeLayout("list-view");this.searchPageModule.getCurrentLayout().isIssueViewActive=function(){return true};ok(!this.searchPageModule.handleDown(),"Can't navigate down when issue view is active");ok(!this.searchPageModule.handleUp(),"Can't navigate up when issue view is active");this.searchPageModule.getCurrentLayout().isIssueViewActive=function(){return false};ok(this.searchPageModule.handleDown(),"Handle down returns true if navigated");equal(a.callCount,1,"Next issue called");this.searchPageModule.searchResults.isFirstIssueHighlighted=function(){return true};ok(!this.searchPageModule.handleUp(),"Can't navigate up when first issue is highlighted");this.searchPageModule.searchResults.isFirstIssueHighlighted=function(){return false};ok(this.searchPageModule.handleUp(),"Handle up returns true if navigated");equal(b.callCount,1,"Previous issue called")});test("Changing layouts scrolls to top of page",function(){var d=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var f=sinon.stub().returns(d);var c=_.extend({close:sinon.spy(),render:sinon.spy()},Backbone.Events);var a=sinon.stub().returns(c);d.__proto__=f.prototype={};c.__proto__=a.prototype={};this.searchPageModule.registerLayout("a",{label:"A",View:f});this.searchPageModule.registerLayout("b",{label:"B",View:a});var b=jQuery("<div />").height(3000).appendTo("body");var e=jQuery("body");e.scrollTop(1000);this.searchPageModule.changeLayout("b");equal(e.scrollTop(),0,"Expected to scroll back to top of page when changing layouts.");b.remove()});test("getState() returns issue module issue key when in standalone mode",function(){this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:getIssueKey").returns("TEST-1");this.searchPageModule.searchResults.getState=sinon.stub().returns({selectedIssueKey:"TEST-2"});this.searchPageModule.standalone=true;var a=this.searchPageModule.getState();equal(a.selectedIssueKey,"TEST-1");this.searchPageModule.standalone=false;a=this.searchPageModule.getState();equal(a.selectedIssueKey,"TEST-2")});test("Next issue code should not be run when there is not currentlayout",function(){var a=_.extend({close:sinon.spy(),render:sinon.spy(),nextIssue:sinon.spy()},Backbone.Events);var b=sinon.stub().returns(a);this.searchPageModule.registerLayout("a",{label:"A",View:b});this.searchPageModule.standalone=true;ok(!this.searchPageModule.nextIssue());this.searchPageModule.changeLayout("a");ok(this.searchPageModule.nextIssue());equal(a.nextIssue.callCount,1)});test("Prev issue code should not be run when there is not currentlayout",function(){var a=_.extend({close:sinon.spy(),render:sinon.spy(),prevIssue:sinon.spy()},Backbone.Events);var b=sinon.stub().returns(a);this.searchPageModule.registerLayout("a",{label:"A",View:b});this.searchPageModule.standalone=true;ok(!this.searchPageModule.prevIssue());this.searchPageModule.changeLayout("a");ok(this.searchPageModule.prevIssue());equal(a.prevIssue.callCount,1)});test("searchPageModule isDirty",function(){ok(!this.searchPageModule.isDirty(),"no filter exists, can't be dirty");this.searchPageModule.setJql("effectiveJql");this.searchPageModule.setFilter(new JIRA.Components.Filters.Models.Filter({jql:"effectiveJql"}));ok(!this.searchPageModule.isDirty(),"filter matches effective jql");this.searchPageModule.setJql("project = TST");ok(this.searchPageModule.isDirty(),"jql does not match filter jql");this.searchPageModule.setJql("effectiveJql");ok(!this.searchPageModule.isDirty(),"back to clean")});test("should set the filter id in the state when the filter is set",function(){var a=new JIRA.Components.Filters.Models.Filter({id:1});this.searchPageModule.setFilter(a);equal(this.searchPageModule.getState().filter,1,"the filter id")});test("should reset to blank when a filter is removed",function(){var a=new JIRA.Components.Filters.Models.Filter({id:1});this.searchPageModule.setFilter(a);this.searchPageModule.filterModule.trigger("filterRemoved",{filterId:1});equal(this.searchPageModule.getState().filter,null)});test("should not reset to blank when the filter removed is not the current filter",function(){var a=new JIRA.Components.Filters.Models.Filter({id:1});this.searchPageModule.setFilter(a);this.searchPageModule.filterModule.trigger("filterRemoved",{filterId:2});equal(this.searchPageModule.getState().filter,1)});test("should not throw an exception when a filter is removed and there is no current filter",function(){this.searchPageModule.filterModule.trigger("filterRemoved",{filterId:2});ok(true,"no exception thrown")});test("should stop listening to filterRemoved events on the old filter module when a new filter module is set",function(){var b=new JIRA.Components.Filters.Models.Filter({id:1});this.searchPageModule.setFilter(b);var a=this.searchPageModule.filterModule;this.searchPageModule.registerFilterModule(new JIRA.Issues.MockFilterModule());a.trigger("filterRemoved",{filterId:1});equal(this.searchPageModule.getState().filter,1)});test("should reset to filter when a filter is selected",function(){this.searchPageModule.filterModule.trigger("filterSelected",{filterId:1});equal(JIRA.Issues.Application.execute.withArgs("navigation:navigate").callCount,1,"Navigate action was called");var a=JIRA.Issues.Application.execute.withArgs("navigation:navigate").firstCall.args[1].filter;equal(a,1,"issueNavRouter.pushState args.filter")});test("should stop listening to filterSelected events on the old filter module when a new filter module is set",function(){var a=this.searchPageModule.filterModule;this.searchPageModule.registerFilterModule(new JIRA.Issues.MockFilterModule());a.trigger("filterSelected",{filterId:1});equal(JIRA.Issues.Application.execute.callCount,0,"issueNavRouter.pushState.callCount")});test("Applying a new filter to the state should update the window's title",function(){var a=this.stub(this.searchPageModule,"updateWindowTitle");this.searchPageModule.filterModule.getFilterById.returns(new jQuery.Deferred().resolve().promise());this.stub(this.searchPageModule,"initSystemFilters").returns(new jQuery.Deferred().resolve().promise());this.searchPageModule.applyState({jql:"",filter:1},true);ok(a.called,"Window title updated.")});test("When the JQL changes, it updates the Filter header",function(){this.stub(this.searchPageModule.filterModule,"updateFilterHeader");this.searchPageModule.queryModule.trigger("searchChanged",{newJql:""});sinon.assert.calledOnce(this.searchPageModule.filterModule.updateFilterHeader)});test("When the JQL changes, it marks the Filter header as edited if the new JQL doesn't match the filter's JQL",function(){var a="project = DEMO";this.stub(this.searchPageModule.filterModule,"updateFilterHeader");this.stub(this.searchPageModule,"getState").returns({filterJql:"project = FILTER",jql:a});this.searchPageModule.queryModule.trigger("searchChanged",{newJql:a});sinon.assert.calledWith(this.searchPageModule.filterModule.updateFilterHeader,{isEdited:true,isPendingSearch:false})});test("When the JQL changes, it marks the Filter header as edited if the JQL in the search box doesn't match the state JQL",function(){this.stub(this.searchPageModule.filterModule,"updateFilterHeader");this.stub(this.searchPageModule,"getState").returns({filterJql:"project = FILTER",jql:"project = FILTER"});this.searchPageModule.queryModule.trigger("searchChanged",{newJql:"project = DEMO"});sinon.assert.calledWith(this.searchPageModule.filterModule.updateFilterHeader,{isEdited:true,isPendingSearch:true})});test("When the kb shortcuts are enabled and there is a current layout, it can focus the issue list",function(){AJS.keyboardShortcutsDisabled=false;this.searchPageModule.changeLayout("split-view");this.searchPageModule.focusIssueList();sinon.assert.calledOnce(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueList)});test("When the kb shortcuts are disabled, it doesn't focus the issue list",function(){AJS.keyboardShortcutsDisabled=true;this.searchPageModule.changeLayout("split-view");this.searchPageModule.focusIssueList();sinon.assert.notCalled(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueList)});test("When there is no active layout, it doesn't focus the issue list",function(){AJS.keyboardShortcutsDisabled=true;this.stub(this.searchPageModule,"getCurrentLayout").returns(null);this.searchPageModule.focusIssueList();sinon.assert.notCalled(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueList)});test("When the kb shortcuts are enabled and there is a current layout, it can focus the issue editor",function(){AJS.keyboardShortcutsDisabled=false;this.searchPageModule.changeLayout("split-view");this.searchPageModule.focusIssueEditor();sinon.assert.calledOnce(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueEditor)});test("When the kb shortcuts are disabled, it doesn't focus the issue editor",function(){AJS.keyboardShortcutsDisabled=true;this.searchPageModule.changeLayout("split-view");this.searchPageModule.focusIssueEditor();sinon.assert.notCalled(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueEditor)});test("When there is no active layout, it doesn't focus the issue editor",function(){AJS.keyboardShortcutsDisabled=true;this.stub(this.searchPageModule,"getCurrentLayout").returns(null);this.searchPageModule.focusIssueEditor();sinon.assert.notCalled(this.searchPageModule.getLayout("split-view").View.prototype.focusIssueEditor)})});