define('jira/issues/search/legacyissuenavigatorshortcuts', [
    'jira/issues/search/legacyissuenavigator',
    'jira/focus/set-focus',
    'jira/ajs/persistence',
    'jira/util/events',
    'jira/issue',
    'jira/message',
    'jquery'
], function (
    IssueNavigator,/** @todo TF-711 remove. */
    SetFocus,
    Persistence,
    Events,
    Issue,
    Messages,
    jQuery
) {
    "use strict";

    /**
     * @deprecated should all be superceded by {@link JIRA.Issues.Api}.
     * @todo TF-711 remove entirely.
     * @exports jira/issuenavigator/issue-navigator/shortcuts
     * @namespace JIRA.IssueNavigator.Shortcuts
     */
    var Shortcuts = {};

    var $rows;
    var index;
    var helpText;

    var issueIdToRowIndex = {};

    /**
     * Links the old IssueNavigator calls to the new JIRA.Issues.Api calls. This function is needed because we cannot
     * just 'require' the AMD module because JIRA.Issue might not be initialized.
     */
    Shortcuts.initialize = function() {

        Shortcuts.isNavigator = function() {
            return IssueNavigator.isNavigator();
        };

        Shortcuts.selectNextIssue = function() {
            return JIRA.Issues.Api.nextIssue();
        };

        Shortcuts.selectPreviousIssue = function() {
            return JIRA.Issues.Api.prevIssue();
        };

        Shortcuts.viewSelectedIssue = function() {
            return JIRA.Issues.Api.viewSelectedIssue();
        };

        Shortcuts.focusSearch = function() {
            JIRA.Issues.Api.focusSearch();
        };
    };

    Shortcuts._quickEditSessionCompleteHandler = jQuery.noop;

    Shortcuts._quickCreateSubtaskSessionCompleteHandler = jQuery.noop;

    Shortcuts.isNavigator = jQuery.noop;

    Shortcuts.selectNextIssue = jQuery.noop;

    Shortcuts.selectPreviousIssue = jQuery.noop;

    Shortcuts.viewSelectedIssue = jQuery.noop;

    Shortcuts.focusSearch = jQuery.noop;

    /**
     * Called to focus the row on the first row or the specified row if issueId is specified
     * @param issueId an optional issueIf to focus on
     * @param delay the delay before triggering ajax issue selection
     * @param supressLinkFocus Do not focus on the first link in the row if this is true.
     */
    Shortcuts.focusRow = function(issueId, delay, supressLinkFocus) {
        if (hasResults()) {
            if (issueId) {
                selectRowViaIssueId(issueId, delay, supressLinkFocus);
            } else {
                if (!supressLinkFocus){
                    jQuery($rows[index]).find('a:first').focus();
                }
            }
        }
    };

    jQuery(document).ready(function() {

        if (IssueNavigator.isNavigator()) {
            // this block is supposed to keep the focus in the search text box so that it is easy to continue editing searches.
            var shouldFocusSearch = jQuery("#focusSearch").attr("content") === "true";

            /*
             * This is used to set the focus away from an input box if they are coming back from a previous search.
             * The server is setting the #focusSearch meta property to true if its a new search and hence the focus will auto go to the input box.
             * But if its not a new search then we want to blur away from the input box so that keyboard shortcuts work
             */
            if (!shouldFocusSearch) {
                var activeElement = jQuery(document.activeElement);
                if (activeElement.is(":input")) {
                    activeElement.blur();
                }
            }


            if (hasResults() && !jQuery(document.activeElement).is(":input")) {
                setTimeout(function () {
                    $rows.eq(index).scrollIntoView();
                }, 0);
            }

            jQuery(".issue-actions-trigger").click(function(){
                var $row = jQuery(this).closest("tr");
                var issueId = $row.attr("rel");
                if (issueId){
                    Shortcuts.focusRow(issueId, 0, true);
                }
            });
        }
    });

    function hasResults() {
        return $rows && $rows.length > 0;
    }

    function unselectRow(i) {
        var $td = jQuery($rows[i]).find('td:first');
        jQuery($rows[i]).removeClass('focused');
        helpText = $td.attr('title');
        $td.removeAttr('title');
    }

    function selectRow(i, delay, supressLinkFocus) {
        var $selected = jQuery($rows[i]).addClass('focused').scrollIntoView();
        $selected.find('td').first().attr('title', helpText);
        if (!supressLinkFocus){
            focusRow(i);
        }
    }

    function selectRowViaIssueId(issueId, delay, supressLinkFocus) {
        var newIndex = issueIdToRowIndex[issueId];
        if (newIndex || newIndex === 0) {
            unselectRow(index);
            selectRow(index = newIndex, delay, supressLinkFocus);
        }
    }

    // This is here so tab and enter work correctly while traversing the navigator list.
    function focusRow(i) {
        var $selected = jQuery($rows[i]);
        $selected.find('.hidden-link')
            .removeAttr('tabIndex')
            .focus();
    }

    return Shortcuts;
});
